unit KwazyQuiltPuzzleNo7114_android_unit;

// 1641 variants of solution exists

//{$mode delphi} // original
{$mode objfpc}{$H+} // mantas added

interface

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, SysUtils, AndroidWidget, Laz_And_Controls, FPimage, LCLType,
  Graphics, graphtype, And_jni, Spinner, seekbar, fileprovider, stablayout,
  intentmanager, preferences, math, DateUtils, BGRABitmap, BGRABitmapTypes,
  FPWritePNG;
  //FPWriteBMP;

  
type

  { TPuzzleGameForm }

  TPuzzleGameForm = class(jForm)
    AddDeletePlayerButton: jButton;
    jFileProviderAssets: jFileProvider;    
    jFileProviderInternal: jFileProvider;    
    ImportSavedSolutionsButton: jButton;
    ExportSavedSolutionsButton: jButton;
    OtherPlatformsButton: jButton;
    jDialogYN1: jDialogYN;
    piece13Bitmap: jBitmap;
    piece12Bitmap: jBitmap;
    piece11Bitmap: jBitmap;
    piece10Bitmap: jBitmap;
    piece09Bitmap: jBitmap;
    piece08Bitmap: jBitmap;
    piece07Bitmap: jBitmap;
    piece06Bitmap: jBitmap;
    piece05Bitmap: jBitmap;
    piece04Bitmap: jBitmap;
    piece03Bitmap: jBitmap;
    piece02Bitmap: jBitmap;
    piece01Bitmap: jBitmap;
    BoardBitmap: jBitmap;
    jPreferences1: jPreferences;
    Rot60MinusButton: jButton;
    Rot60PlusButton: jButton;
    jIntentManager1: jIntentManager;
    RateAppButton: jButton;
    MoreAppsButton: jButton;
    piece09BitmapRotated: jBitmap;
    piece10BitmapRotated: jBitmap;
    piece11BitmapRotated: jBitmap;
    piece12BitmapRotated: jBitmap;
    piece13BitmapRotated: jBitmap;
    piece01BitmapRotated: jBitmap;
    piece02BitmapRotated: jBitmap;
    piece03BitmapRotated: jBitmap;
    piece04BitmapRotated: jBitmap;
    piece05BitmapRotated: jBitmap;
    piece06BitmapRotated: jBitmap;
    piece07BitmapRotated: jBitmap;
    piece08BitmapRotated: jBitmap;
    PieceRotationTrackBar: jSeekBar;
    TabLayout1: jsTabLayout;
    TableCanvas: jCanvas;
    ShowSavedSolutionsButton: jButton;
    NewGameButton: jButton;
    FlipButton: jButton;
    FixButton: jButton;
    PlayerNameEdit: jEditText;
    jBitmap1: jBitmap;
    BackgroundCanvas: jCanvas;
    jImageList1: jImageList;
    TableView: jView;
    //----------------------------------



    {$IFDEF ANDROID}
    MoveToNearestSlotAnimationTimer: jTimer;
    RotateToNearest60angleAnimationTimer: jTimer;
    ShowSolutionsTimer: jTimer;
    OutputLabel: jTextView;
    DateLabel: jTextView;
    DebugLabel: jTextView;
    PlayerSelectComboBox: jSpinner;
    AboutWebView: jWebView;
    PlayerNameLabel: jTextView;
    TableViewRefreshTimer: jTimer;
    {$ELSE}
    MoveToNearestSlotAnimationTimer: TTimer;
    RotateToNearest60angleAnimationTimer: TTimer;
    ShowSolutionsTimer: TTimer;
    {$ENDIF}


     procedure AddDeletePlayerButtonClick(Sender: TObject);
     procedure ExportSavedSolutionsButtonClick(Sender: TObject);
     procedure FixButtonClick(Sender: TObject);
     procedure FlipButtonClick(Sender: TObject);
     procedure ImportSavedSolutionsButtonClick(Sender: TObject);
     procedure jDialogYN1ClickYN(Sender: TObject; YN: TClickYN);
     procedure MoreAppsButtonClick(Sender: TObject);
     procedure OtherPlatformsButtonClick(Sender: TObject);

     procedure Piece01MouseUp(X, Y: Integer);
     procedure Piece02MouseUp(X, Y: Integer);
     procedure Piece03MouseUp(X, Y: Integer);
     procedure Piece04MouseUp(X, Y: Integer);
     procedure Piece05MouseUp(X, Y: Integer);
     procedure Piece06MouseUp(X, Y: Integer);
     procedure Piece07MouseUp(X, Y: Integer);
     procedure Piece08MouseUp(X, Y: Integer);
     procedure Piece09MouseUp(X, Y: Integer);
     procedure Piece10MouseUp(X, Y: Integer);
     procedure Piece11MouseUp(X, Y: Integer);
     procedure Piece12MouseUp(X, Y: Integer);
     procedure Piece13MouseUp(X, Y: Integer);


     procedure Piece13Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece01Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece02Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece03Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece04Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece05Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece06Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece07Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece08Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece09Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece10Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece11Redraw(Sender: TObject; Bitmap: TBGRABitmap);
     procedure Piece12Redraw(Sender: TObject; Bitmap: TBGRABitmap);


     procedure MoveToNearestSlotAnimationTimerStartTimer();


(*
    procedure RotateToNearest60angleAnimationTimerStartTimer(Sender: TObject);
    procedure RotateToNearest60angleAnimationTimerTimer(Sender: TObject);
*)

//-----------------
    procedure MoveToNearestSlotAnimationTimerTimer(Sender: TObject);
    procedure NewGameButtonClick(Sender: TObject);
    procedure PieceRotationTrackBarProgressChanged(Sender: TObject; progress: integer; fromUser: boolean);
    procedure PlayerSelectComboBoxItemSelected(Sender: TObject; itemCaption: string; itemIndex: integer);
    procedure PuzzleGameFormActivityResult(Sender: TObject;
      requestCode: integer; resultCode: TAndroidResult; intentData: jObject);
    procedure PuzzleGameFormClose(Sender: TObject);
    procedure PuzzleGameFormJNIPrompt(Sender: TObject);
    procedure PuzzleGameFormRequestPermissionResult(Sender: TObject;
      requestCode: integer; manifestPermission: string;
      grantResult: TManifestPermissionResult);
    procedure PuzzleGameFormRotate(Sender: TObject; rotate: TScreenStyle);
    procedure PuzzleGameFormShow(Sender: TObject);
    procedure PuzzleGameFormSpecialKeyDown(Sender: TObject; keyChar: char; keyCode: integer; keyCodeString: string; var mute: boolean);
    procedure RateAppButtonClick(Sender: TObject);
    procedure Rot60MinusButtonClick(Sender: TObject);
    procedure Rot60PlusButtonClick(Sender: TObject);
    procedure TabLayout1TabSelected(Sender: TObject; position: integer; title: string);
    procedure TableViewDraw(Sender: TObject);
    procedure TableViewTouchDown(Sender: TObject; Touch: TMouch);
    procedure TableViewTouchMove(Sender: TObject; Touch: TMouch);
    procedure RotateToNearest60angleAnimationTimerTimer(Sender: TObject);
    procedure ShowSavedSolutionsButtonClick(Sender: TObject);
    procedure ShowSolutionsTimerTimer(Sender: TObject);
    procedure TableViewTouchUp(Sender: TObject; Touch: TMouch);


  private

    procedure CreatePieceBitmaps();
    procedure CreatePieceBitmapsTBGRABitmap();
    procedure DrawBackgroundOfBoard();
    procedure RotatePiece();

    procedure RedrawCurrentPiece();
    procedure RedrawCurrentPieceFromTBGRABitmap();
    procedure RedrawAllPieces();
    procedure SimplifySolution();
    procedure LoadPiecesIntoBoard();
    procedure LoadNextSolution(slideshow_direction: Integer);
    procedure ClearBoard();
    procedure ClearSlot(slot_number: Integer);
    procedure StartNewGame();
    procedure PlacePieceToStartPosition(piece_number: Integer);
    procedure ConvertPieceSlotPositionIntoSlotContent(piece_slot_position: Integer; piece_number: Integer);
    procedure PlacePieceIntoBoardToFindCollisions(piece_number: Integer; slot_number: Integer);
    function FindCollidingSpikesCoordinates(slot_number_1: Integer; spike_position_1: Integer; slot_number_2: Integer; spike_position_2: Integer): Integer;
    procedure SaveSolution();
    procedure FixBugOfEmptySlot();
    procedure RedrawAllPiecesAfterSimplifySolution();
    procedure UpdateSavedPuzzleFile(new_filename: TFileName; old_filename: TFileName);
    procedure CopyFilesFromAssetsToInternalDirectory();
    procedure LoadPlayerNames();

  public
    {public declarations}
    finger_coordinates: TPoint;  // delete
    Ratio : Single; // delete
//---------------------------------------
    board_image: TBGRABitmap;
    piece_image_01: TBGRABitmap;
    piece_image_02: TBGRABitmap;
    piece_image_03: TBGRABitmap;
    piece_image_04: TBGRABitmap;
    piece_image_05: TBGRABitmap;
    piece_image_06: TBGRABitmap;
    piece_image_07: TBGRABitmap;
    piece_image_08: TBGRABitmap;
    piece_image_09: TBGRABitmap;
    piece_image_10: TBGRABitmap;
    piece_image_11: TBGRABitmap;
    piece_image_12: TBGRABitmap;
    piece_image_13: TBGRABitmap;
    output_image: TBGRABitmap;



  end;

var
  PuzzleGameForm: TPuzzleGameForm;

//------------------------------------
  bitmap_resource: TBitmap;
  png: TPortableNetworkGraphic;


  screen_density_rescale: Double;

  board_offset_x, board_offset_y: Integer;
  x_distance_between_slots, y_distance_between_slots, distance_between_pieces, pieces_top: Integer;

  board_border_x_center: array [0 .. 15] of integer;
  board_border_y_center: array [0 .. 15] of integer;
  board_border_radius: Single;
  board_border_color: TBGRAPixel;
  board_border_pen_width, error_circle_pen_width, error_circle_pen_width_div_2: Integer;


  saved_current_piece: Integer;
  previous_current_piece: Integer;
  current_piece: Integer;
  current_slot: Integer;


  piece_rotation_angle: array [0 .. 12] of Integer;
  piece_is_flipped: array [0 .. 12] of Boolean;
  piece_slot_address: array [0 .. 12] of Integer;


  slot_content: array [0 .. 12] of Integer;
  slot_left: array [0 .. 12] of integer;
  slot_top: array [0 .. 12] of integer;
  slot_x_center: array [0 .. 12] of integer;
  slot_y_center: array [0 .. 12] of integer;


  piece_quarter_size: Integer;
  piece_half_size: Integer;

  current_piece_marking_ellipse_radius, current_piece_marking_ellipse_diameter: Integer;
  current_piece_marking_ellipse_rect: TRect;

  error_spike_angle: Double;


  x_animation_increment, y_animation_increment, current_x_position, current_y_position: Double;
  number_of_animation_steps: Double;
  current_rotation_angle, final_rotation_angle, rotation_increment: Integer;
  rotation_increment_default: Integer;
  angle_difference: Integer;
  mouse_rotation_angle_difference, mouse_rotation_angle, mouse_rotation_angle_original: Double;
  angle_6th_part: Double;

  mousetop, mouseleft: Integer;
  clicked_X, clicked_Y: Integer;
  distance_x, distance_y, distance_r: Integer;
  rotation_mode: Boolean;
  mouse_button_pressed: Boolean;


//  saved_all_puzzles_stringlist, fixed_puzzle_stringlist: jEditText;
  saved_all_puzzles_stringlist, fixed_puzzle_stringlist, temp_puzzle_stringlist: TStringList;
  old_merge_puzzle_stringlist, new_merge_puzzle_stringlist, difference_merge_puzzle_stringlist, sorted_merge_puzzle_stringlist: TStringList;
  empty_stringlist: TStringList;



  solved_puzzle_string: String;
  saved_puzzle_number: Integer;

  slideshow_mode: Boolean;
  redraw_pieces_after_simplify_solution: Boolean;
  saved_puzzle_stringlist: TStringList;
  date_and_time_string, old_date_and_time_string: String;


  file_handle: Longint;
  resources_filepath: TFileName;
  player_names_filename,  player_names_full_filename,  player_names_filepath: TFileName;


//  player_names_stringlist: jEditText;
  player_names_stringlist: TStringList;



  puzzle_solutions_filename, puzzle_solutions_full_filename, puzzle_solutions_filepath: TFileName;
  puzzle_solutions_saved_file_age: Integer;
  current_date: TDateTime;


  {$IFDEF ANDROID}
  error_circle_image_left: Integer;
  error_circle_image_top: Integer;

  error_circle_image_width: Integer;
  error_circle_image_height: Integer;

  piece01_width: Integer;
  piece01_height: Integer;
  piece02_width: Integer;
  piece02_height: Integer;
  piece03_width: Integer;
  piece03_height: Integer;
  piece04_width: Integer;
  piece04_height: Integer;
  piece05_width: Integer;
  piece05_height: Integer;
  piece06_width: Integer;
  piece06_height: Integer;
  piece07_width: Integer;
  piece07_height: Integer;
  piece08_width: Integer;
  piece08_height: Integer;
  piece09_width: Integer;
  piece09_height: Integer;
  piece10_width: Integer;
  piece10_height: Integer;
  piece11_width: Integer;
  piece11_height: Integer;
  piece12_width: Integer;
  piece12_height: Integer;
  piece13_width: Integer;
  piece13_height: Integer;

  piece01_left: Integer;
  piece01_top: Integer;
  piece02_left: Integer;
  piece02_top: Integer;
  piece03_left: Integer;
  piece03_top: Integer;
  piece04_left: Integer;
  piece04_top: Integer;
  piece05_left: Integer;
  piece05_top: Integer;
  piece06_left: Integer;
  piece06_top: Integer;
  piece07_left: Integer;
  piece07_top: Integer;
  piece08_left: Integer;
  piece08_top: Integer;
  piece09_left: Integer;
  piece09_top: Integer;
  piece10_left: Integer;
  piece10_top: Integer;
  piece11_left: Integer;
  piece11_top: Integer;
  piece12_left: Integer;
  piece12_top: Integer;
  piece13_left: Integer;
  piece13_top: Integer;

  piece01_right: Integer;
  piece01_bottom: Integer;
  piece02_right: Integer;
  piece02_bottom: Integer;
  piece03_right: Integer;
  piece03_bottom: Integer;
  piece04_right: Integer;
  piece04_bottom: Integer;
  piece05_right: Integer;
  piece05_bottom: Integer;
  piece06_right: Integer;
  piece06_bottom: Integer;
  piece07_right: Integer;
  piece07_bottom: Integer;
  piece08_right: Integer;
  piece08_bottom: Integer;
  piece09_right: Integer;
  piece09_bottom: Integer;
  piece10_right: Integer;
  piece10_bottom: Integer;
  piece11_right: Integer;
  piece11_bottom: Integer;
  piece12_right: Integer;
  piece12_bottom: Integer;
  piece13_right: Integer;
  piece13_bottom: Integer;

  memory_stream: TMemoryStream;
  dyn_array_of_jbyte: TDynArrayOfJByte;
  png_writer: TFPWriterPNG;

  background_of_board_already_drawn: Integer;

  PIECE_SIZE: Integer;

  about_html_stringlist: TStringList;

  app_store: Integer;

  redraw_current_piece_finished: Integer;
  tab_layout_height: Integer;
  status_bar_height: Integer;
  board_offset_y_for_table_draw: Integer;
  error_circle_image_visible: Integer;

  screen_width, screen_height, table_width, table_height: Integer;
  screen_width_half_size, screen_height_half_size: Integer;

  congratulations_visible: Integer;
  draw_text_height: Integer;

  can_close: Boolean;
  player_names_loaded: Integer;


  input_treeUri, output_treeUri: jObject;
  input_filename, output_filename: TFileName;
  input_file_size, output_file_size: int64;

  player_name: String;
  player_name_already_exists, matching_solution_found: Integer;

  solved_puzzle_1, solved_puzzle_2, solved_puzzle_2_with_date: String;
  pos_of_quotes: Integer;
  temp_string: String;

  merge_solution_mode: Integer;
  combobox_item_selected, on_app_start_combobox_item_selected: Integer;

  solution_already_exists: Integer;
  solution_already_exists_string_1, solution_already_exists_string_2, solution_already_exists_string_3: String;

  inside_save_solution: Boolean;


  {$ENDIF} // $IFDEF ANDROID



  //const
  //  PIECE_SIZE = 200;

  const OPEN_FILE = 111;
  const SAVE_FILE = 222;


  const GOOGLE_STORE = 1;
  const SAMSUNG_STORE = 2;
  const HUAWEI_STORE = 3;
  const XIAOMI_STORE = 4;
  const AMAZON_STORE = 5;




  //  spikes listed starting from the very top going clockwise
  //  array size 13x6
      piece_spike_table: array of Integer = (
      1, 1, 1, 1, 1, 1, // 1 piece
      1, 1, 1, 0, 1, 1, // 2 piece
      1, 1, 0, 0, 1, 1, // 3 piece
      0, 1, 1, 0, 1, 1, // 4 piece
      1, 0, 1, 1, 1, 0, // 5 piece
      0, 0, 1, 1, 1, 0, // 6 piece
      1, 0, 1, 0, 1, 0, // 7 piece
      1, 0, 0, 1, 1, 0, // 8 piece
      1, 0, 0, 0, 1, 0, // 9 piece
      0, 0, 0, 0, 1, 1, // 10 piece
      1, 0, 0, 1, 0, 0, // 11 piece
      1, 0, 0, 0, 0, 0, // 12 piece
      1, 0, 0, 0, 0, 0); // 13 piece


      board_spike_table: array of Integer = (
      0, 0, 0, 0, 0, 0, // 1 slot
      0, 0, 0, 0, 0, 0, // 2 slot
      0, 0, 0, 0, 0, 0, // 3 slot
      0, 0, 0, 0, 0, 0, // 4 slot
      0, 0, 0, 0, 0, 0, // 5 slot
      0, 0, 0, 0, 0, 0, // 6 slot
      0, 0, 0, 0, 0, 0, // 7 slot
      0, 0, 0, 0, 0, 0, // 8 slot
      0, 0, 0, 0, 0, 0, // 9 slot
      0, 0, 0, 0, 0, 0, // 10 slot
      0, 0, 0, 0, 0, 0, // 11 slot
      0, 0, 0, 0, 0, 0, // 12 slot
      0, 0, 0, 0, 0, 0); // 13 slot


      board_colliding_spikes_table: array of Integer = (
      0, 0, 0, 0, 0, 0, // 1 slot
      0, 0, 0, 0, 0, 0, // 2 slot
      0, 0, 0, 0, 0, 0, // 3 slot
      0, 0, 0, 0, 0, 0, // 4 slot
      0, 0, 0, 0, 0, 0, // 5 slot
      0, 0, 0, 0, 0, 0, // 6 slot
      0, 0, 0, 0, 0, 0, // 7 slot
      0, 0, 0, 0, 0, 0, // 8 slot
      0, 0, 0, 0, 0, 0, // 9 slot
      0, 0, 0, 0, 0, 0, // 10 slot
      0, 0, 0, 0, 0, 0, // 11 slot
      0, 0, 0, 0, 0, 0, // 12 slot
      0, 0, 0, 0, 0, 0); // 13 slot


  
implementation
  
  
{$R *.lfm}
  

  
{ TPuzzleGameForm }

procedure TPuzzleGameForm.TableViewTouchMove(Sender: TObject; Touch: TMouch);
begin

  if(MoveToNearestSlotAnimationTimer.Enabled = true) then
  Exit();

  TableView.OnTouchMove := nil;


  finger_coordinates := Point( Round(Touch.Pt.X), Round(Touch.Pt.Y) );


if((finger_coordinates.X <= piece_quarter_size) or (finger_coordinates.Y <= piece_quarter_size) or (finger_coordinates.X >= table_width) or (finger_coordinates.Y >= table_height)) then // protection from loosing piece outside of screen
  begin
   TableView.OnTouchMove := @TableViewTouchMove;
   Exit();
  end;

  if(current_piece = 1) then
  begin
    piece01_left := finger_coordinates.X - piece_half_size;
    piece01_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 2) then
  begin
    piece02_left := finger_coordinates.X - piece_half_size;
    piece02_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 3) then
  begin
    piece03_left := finger_coordinates.X - piece_half_size;
    piece03_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 4) then
  begin
    piece04_left := finger_coordinates.X - piece_half_size;
    piece04_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 5) then
  begin
    piece05_left := finger_coordinates.X - piece_half_size;
    piece05_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 6) then
  begin
    piece06_left := finger_coordinates.X - piece_half_size;
    piece06_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 7) then
  begin
    piece07_left := finger_coordinates.X - piece_half_size;
    piece07_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 8) then
  begin
    piece08_left := finger_coordinates.X - piece_half_size;
    piece08_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 9) then
  begin
    piece09_left := finger_coordinates.X - piece_half_size;
    piece09_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 10) then
  begin
    piece10_left := finger_coordinates.X - piece_half_size;
    piece10_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 11) then
  begin
    piece11_left := finger_coordinates.X - piece_half_size;
    piece11_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 12) then
  begin
    piece12_left := finger_coordinates.X - piece_half_size;
    piece12_top := finger_coordinates.Y + piece_half_size;
  end
  else if(current_piece = 13) then
  begin
    piece13_left := finger_coordinates.X - piece_half_size;
    piece13_top := finger_coordinates.Y + piece_half_size;
  end;

  if(current_piece > 0) then
  TableView.Refresh();

  previous_current_piece := current_piece;



end;



procedure TPuzzleGameForm.PuzzleGameFormJNIPrompt(Sender: TObject);
begin

  can_close := false;

  player_names_loaded := 0;

  background_of_board_already_drawn := 0;

  congratulations_visible := 0;

//  copy_of_files_from_assets_completed := 0;


  app_store := GOOGLE_STORE;
  //app_store := SAMSUNG_STORE;
  //app_store := HUAWEI_STORE;
  //app_store := XIAOMI_STORE;
  //app_store := AMAZON_STORE;


  PIECE_SIZE := gApp.Screen.WH.Width div 4;

  tab_layout_height := 0;
  tab_layout_height := TabLayout1.GetLParamHeight();

  error_circle_image_visible := 0;

  redraw_current_piece_finished := 1;

  on_app_start_combobox_item_selected := 0;
  combobox_item_selected := 0;


  solution_already_exists := 0;
  solution_already_exists_string_1 := '';
  solution_already_exists_string_2 := '';
  solution_already_exists_string_3 := '';

  inside_save_solution := false;


  finger_coordinates.X:= 0; // delete
  finger_coordinates.Y:= 0; // delete


  player_names_filename := 'puzzle_game_players.txt';


  // https://forum.lazarus.freepascal.org/index.php/topic,72458.0.html
  // jButton - Oval shape
  // FlipButton.SetRadiusRoundCorner(90); // does not work
  // FlipButton.SetRoundCorner(); // does not work


  FlipButton.Visible := true;
  Rot60PlusButton.Visible := true;
  Rot60MinusButton.Visible := true;

  PieceRotationTrackBar.Visible := false; // z-order of TableView hides PieceRotationTrackBar

  NewGameButton.Visible := false;
  ShowSavedSolutionsButton.Visible := false;

  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;
  FixButton.Visible := false;
  PlayerSelectComboBox.Visible := false;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;
  OutputLabel.Visible := false; // OutputLabel is covered by TableView, does not work in Android
  DateLabel.Visible := false;  // DateLabel is covered by TableView, does not work in Android
  DebugLabel.Visible := false;


  MoreAppsButton.Visible := false;
  RateAppButton.Visible := false;
  OtherPlatformsButton.Visible := false;
  AboutWebView.Visible := false;




  if(TabLayout1.GetTabCount() = 0) then
  begin

    //Self.TabLayout1.SetBackgroundToPrimaryColor();
    //Self.TabLayout1.SetElevation(20);
    Self.TabLayout1.SetSelectedTabIndicatorHeight(3);
    Self.TabLayout1.SetSelectedTabIndicatorColor(colbrLime);

    Self.TabLayout1.AddTab('Game');
    Self.TabLayout1.AddTab('Settings');
    Self.TabLayout1.AddTab('About');
   end; // if(TabLayout1.GetTabCount() = 0) then



  //  if (about_html_stringlist <> nil) then about_html_stringlist.Free;
    about_html_stringlist := TStringList.Create();
    about_html_stringlist.Clear();

    about_html_stringlist.Clear();
    about_html_stringlist.Add('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "https://www.w3.org/TR/html4/strict.dtd">');
    about_html_stringlist.Add('<html><head><meta content="text/html; charset=ISO-8859-1" http-equiv="content-type"><title>Neuron model RF-PSTH</title></head>');

    about_html_stringlist.Add('<body><big><b>Kwazy Quilt Puzzle No. 7114 v. ' + Self.GetVersionName() + ' (build: '+ IntToStr(Self.GetVersionCode()) + ')</b></big><br>');
    about_html_stringlist.Add('<br>');

    about_html_stringlist.Add('Two-dimensional packing puzzle consisting of 13 pieces that need to be placed within a frame.<br>');
    about_html_stringlist.Add('“Kwazy Quilt” was registered by Kohner Bros., Inc. at 1966-04-26 (registration number: 0807494), first used at 1964-08-10, expired at 1989-01-10.<br>');
    about_html_stringlist.Add('Later puzzle has also been produced by Tenyo Co., Ltd. in Japan with the name “No. 0 Beat the Computer”, and also the same puzzle was made in Soviet Union, in Donetsk, Ukraine (approximately year 1989).<br>');
    about_html_stringlist.Add('Japan and Soviet instruction leaflets claimed that puzzle has 1641 solutions, however this number might be incorrect.<br>');
    about_html_stringlist.Add('<br>');
    about_html_stringlist.Add('Free open-source cross-platform software.<br>');
    about_html_stringlist.Add('<br>');

    about_html_stringlist.Add('More games are available at the address:<br>');
//    about_html_stringlist.Add('<a href="https://games.cognaxon.com">https://games.cognaxon.com</a><br>');
    about_html_stringlist.Add('https://games.cognaxon.com<br>');

    about_html_stringlist.Add('<br>');
    about_html_stringlist.Add('Kwazy Quilt Puzzle No. 7114 compiled for Android, compilation date: ' + {$include %date%} + ', time: ' + Format('%.*d',[2, {$include %timeHour%}]) + ':' + Format('%.*d',[2, {$include %timeMinute%}]) );
    about_html_stringlist.Add('<br>');
    about_html_stringlist.Add('<br>');
    about_html_stringlist.Add('</body></html>');


    AboutWebView.LoadFromHtmlString(about_html_stringlist.Text);




  BackgroundCanvas.CreateBitmap(gApp.Screen.WH.Width, gApp.Screen.WH.Height, colbrDefault); // default=transparent
//  BackgroundCanvas.CreateBitmap(TableView.Width, TableView.Height, colbrDefault); // default=transparent
//  TableCanvas.CreateBitmap(TableView.Width, TableView.Height, colbrDefault); // default=transparent






// jFileProviderAssets.SetAuthorities('com.cognaxon.KwazyQuiltPuzzleNo7114');   //works
  jFileProviderAssets.SetAuthorities(Self.PackageName);  //works
  jFileProviderAssets.FileSource:= srcAssets;
  

// jFileProviderInternal.SetAuthorities('com.cognaxon.KwazyQuiltPuzzleNo7114');   //works
  jFileProviderInternal.SetAuthorities(Self.PackageName);  //works
  jFileProviderInternal.FileSource:= srcInternal;

  


  jBitmap1.ImageIndex := 0;
  piece_image_01 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
//piece_image_01.Fill(BGRABlack);
  piece_image_02 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_03 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_04 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_05 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_06 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_07 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_08 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_09 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_10 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_11 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_12 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);
  piece_image_13 := TBGRABitmap.Create(jBitmap1.Width, jBitmap1.Height);


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_01.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_01.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_02.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_02.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_03.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_03.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_04.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_04.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;

  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_05.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_05.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_06.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_06.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_07.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_07.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_08.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_08.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;

  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_09.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_09.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_10.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_10.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_11.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_11.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_12.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_12.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;


  dyn_array_of_jbyte := jFileProviderAssets.GetContent('part_12.png');
  try
    memory_stream := TMemoryStream.Create;
    if Length(dyn_array_of_jbyte) > 0 then
    begin
      memory_stream.Write(dyn_array_of_jbyte[0], Length(dyn_array_of_jbyte));
      memory_stream.Seek(0,0);  // position stream for reading
      // memory_stream.Position := 0;
      piece_image_13.LoadFromStream(memory_stream);
     end;
  finally
    memory_stream.Free;
  end;



  player_names_stringlist := TStringList.Create();


  //PlayerSelectComboBox.Top := -100;
  PlayerNameEdit.Text := '';




  current_slot := 0;
  error_spike_angle := 0.0;

  slideshow_mode := false;
  redraw_pieces_after_simplify_solution := false;


//  board_border_color := TColor($012188);
  board_border_color := TColor($566a85); // <<<-----  R and B colors are inverted RGB becomes BRG

  board_border_pen_width := 9;
  error_circle_pen_width := 10;
  error_circle_pen_width_div_2 := error_circle_pen_width div 2;



  mousetop := 0;
  mouseleft := 0;

  saved_puzzle_number := 0;




  saved_all_puzzles_stringlist := TStringList.Create();
  fixed_puzzle_stringlist := TStringList.Create();
  temp_puzzle_stringlist := TStringList.Create();
  old_merge_puzzle_stringlist := TStringList.Create();
  new_merge_puzzle_stringlist := TStringList.Create();
  difference_merge_puzzle_stringlist := TStringList.Create();
  sorted_merge_puzzle_stringlist := TStringList.Create();
  empty_stringlist := TStringList.Create();



  saved_current_piece := 0;
  previous_current_piece := -1;
  current_piece := 0;
  mouse_button_pressed := false;

  number_of_animation_steps := 10.0;




  current_rotation_angle := 0;
  final_rotation_angle := 0;
  rotation_increment := 0;
  angle_difference := 0;
  rotation_increment_default := 5;


  distance_x := 0;
  distance_y := 0;
  distance_r := 0;
  rotation_mode := false;
  mouse_rotation_angle_difference := 0.0;
  mouse_rotation_angle := 0.0;
  mouse_rotation_angle_original := 0.0;






    piece_half_size := PIECE_SIZE div 2;
    piece_quarter_size := PIECE_SIZE div 4;
  //  piece_quarter_size := PIECE_SIZE div 2;

    current_piece_marking_ellipse_radius := PIECE_SIZE div 16;
    current_piece_marking_ellipse_diameter := current_piece_marking_ellipse_radius * 2;

    screen_density_rescale := Self.GetScreenRealXdpi() / 160.0;
    //screen_density_rescale := Self.GetScreenRealYdpi() / 160.0;

    board_offset_x := 20;
    //board_offset_y := 30; // original
    //board_offset_y := 60;
//   board_offset_y := tab_layout_height + piece_half_size; // + 30; // missmatch due to height of Android statusbar // PIECE_SIZE => on S9 Phone = 360, on Tablet = 225 // tab_layout_height = 192 on Samsung S9 // DEBUG DELETE
//    board_offset_y := Round( Double(tab_layout_height) * 3.0 / screen_density_rescale) + piece_half_size; // ;  // PIECE_SIZE => on S9 Phone = 360, on Tablet = 225
    board_offset_y := tab_layout_height + 180;


    status_bar_height := 0;

//          function GetBatteryPercent : integer; // BY ADiV
//          function GetStatusBarHeight: integer; // BY ADiV
//          function GetActionBarHeight: integer; // BY ADiV
//          function GetContextTop: integer;        // BY ADiV
//          function GetNavigationHeight : integer; // BY ADiV

    status_bar_height := GetStatusBarHeight(); // 96 on Samsung S9
    board_offset_y_for_table_draw := PIECE_SIZE - 12; // board_offset_y - status_bar_height;
    // board_offset_y_for_table_draw = 348, PIECE_SIZE = 336, piece_half_size = 168
    // tab_layout.GetHeight = 49


    screen_width := 0;
    screen_height := 0;
    table_width := 0;
    table_height := 0;

    screen_width := gApp.Screen.WH.Width;
    screen_height := gApp.Screen.WH.Height;

    screen_width_half_size := screen_width div 2;
    screen_height_half_size := screen_height div 2;

//          table_width := screen_width - piece_half_size;
//          table_height := screen_height - GetStatusBarHeight() - GetNavigationHeight() - tab_layout_height - piece_half_size;
    table_width := screen_width - piece_quarter_size;
    table_height := screen_height - GetStatusBarHeight() - GetNavigationHeight() - piece_quarter_size;



    board_border_radius := 0.0;

    error_circle_image_width := current_piece_marking_ellipse_diameter + error_circle_pen_width;
    error_circle_image_height := current_piece_marking_ellipse_diameter + error_circle_pen_width;

    piece01_width := PIECE_SIZE;
    piece01_height:= PIECE_SIZE;
    piece02_width := PIECE_SIZE;
    piece02_height:= PIECE_SIZE;
    piece03_width := PIECE_SIZE;
    piece03_height:= PIECE_SIZE;
    piece04_width := PIECE_SIZE;
    piece04_height:= PIECE_SIZE;
    piece05_width := PIECE_SIZE;
    piece05_height:= PIECE_SIZE;
    piece06_width := PIECE_SIZE;
    piece06_height:= PIECE_SIZE;
    piece07_width := PIECE_SIZE;
    piece07_height:= PIECE_SIZE;
    piece08_width := PIECE_SIZE;
    piece08_height:= PIECE_SIZE;
    piece09_width := PIECE_SIZE;
    piece09_height:= PIECE_SIZE;
    piece10_width := PIECE_SIZE;
    piece10_height:= PIECE_SIZE;
    piece11_width := PIECE_SIZE;
    piece11_height:= PIECE_SIZE;
    piece12_width := PIECE_SIZE;
    piece12_height:= PIECE_SIZE;
    piece13_width := PIECE_SIZE;
    piece13_height:= PIECE_SIZE;





    board_border_radius := PIECE_SIZE * 0.32;


    current_piece_marking_ellipse_rect := TRect.Create(piece_half_size - current_piece_marking_ellipse_radius, piece_half_size - current_piece_marking_ellipse_radius, piece_half_size + current_piece_marking_ellipse_radius, piece_half_size + current_piece_marking_ellipse_radius);



     piece_slot_address[0] := 0;
     piece_slot_address[1] := 0;
     piece_slot_address[2] := 0;
     piece_slot_address[3] := 0;
     piece_slot_address[4] := 0;
     piece_slot_address[5] := 0;
     piece_slot_address[6] := 0;
     piece_slot_address[7] := 0;
     piece_slot_address[8] := 0;
     piece_slot_address[9] := 0;
     piece_slot_address[10] := 0;
     piece_slot_address[11] := 0;
     piece_slot_address[12] := 0;


     //pieces_top := 460;
     pieces_top := Round(PIECE_SIZE * 3.5);

   //  x_distance_between_slots := Round(PIECE_SIZE*0.66);
   //  y_distance_between_slots := Round(PIECE_SIZE*0.5);

     x_distance_between_slots := Round(PIECE_SIZE*0.68);
     y_distance_between_slots := Round(PIECE_SIZE*0.60);



     distance_between_pieces := Round(PIECE_SIZE*1.0);



     slot_left[0] := x_distance_between_slots div 2 + board_offset_x;
     slot_left[1] := x_distance_between_slots div 2 + x_distance_between_slots + board_offset_x;
     slot_left[2] := x_distance_between_slots div 2 + x_distance_between_slots*2 + board_offset_x;
     slot_left[3] := x_distance_between_slots div 2 + x_distance_between_slots*3 + board_offset_x;
     slot_left[4] := 0 + board_offset_x;
     slot_left[5] := x_distance_between_slots + board_offset_x;
     slot_left[6] := x_distance_between_slots*2 + board_offset_x;
     slot_left[7] := x_distance_between_slots*3 + board_offset_x;
     slot_left[8] := x_distance_between_slots*4 + board_offset_x;
     slot_left[9] := x_distance_between_slots div 2 + board_offset_x;
     slot_left[10] := x_distance_between_slots div 2 + x_distance_between_slots + board_offset_x;
     slot_left[11] := x_distance_between_slots div 2 + x_distance_between_slots*2 + board_offset_x;
     slot_left[12] := x_distance_between_slots div 2 + x_distance_between_slots*3 + board_offset_x;





     slot_top[0] := 0 + board_offset_y;
     slot_top[1] := 0 + board_offset_y;
     slot_top[2] := 0 + board_offset_y;
     slot_top[3] := 0 + board_offset_y;
     slot_top[4] := y_distance_between_slots + board_offset_y;
     slot_top[5] := y_distance_between_slots + board_offset_y;
     slot_top[6] := y_distance_between_slots + board_offset_y;
     slot_top[7] := y_distance_between_slots + board_offset_y;
     slot_top[8] := y_distance_between_slots + board_offset_y;
     slot_top[9] := y_distance_between_slots*2 + board_offset_y;
     slot_top[10] := y_distance_between_slots*2 + board_offset_y;
     slot_top[11] := y_distance_between_slots*2 + board_offset_y;
     slot_top[12] := y_distance_between_slots*2 + board_offset_y;



     slot_x_center[0] := slot_left[0] + piece_half_size;
     slot_x_center[1] := slot_left[1] + piece_half_size;
     slot_x_center[2] := slot_left[2] + piece_half_size;
     slot_x_center[3] := slot_left[3] + piece_half_size;
     slot_x_center[4] := slot_left[4] + piece_half_size;
     slot_x_center[5] := slot_left[5] + piece_half_size;
     slot_x_center[6] := slot_left[6] + piece_half_size;
     slot_x_center[7] := slot_left[7] + piece_half_size;
     slot_x_center[8] := slot_left[8] + piece_half_size;
     slot_x_center[9] := slot_left[9] + piece_half_size;
     slot_x_center[10] := slot_left[10] + piece_half_size;
     slot_x_center[11] := slot_left[11] + piece_half_size;
     slot_x_center[12] := slot_left[12] + piece_half_size;


     slot_y_center[0] := slot_top[0] + piece_half_size;
     slot_y_center[1] := slot_top[1] + piece_half_size;
     slot_y_center[2] := slot_top[2] + piece_half_size;
     slot_y_center[3] := slot_top[3] + piece_half_size;
     slot_y_center[4] := slot_top[4] + piece_half_size;
     slot_y_center[5] := slot_top[5] + piece_half_size;
     slot_y_center[6] := slot_top[6] + piece_half_size;
     slot_y_center[7] := slot_top[7] + piece_half_size;
     slot_y_center[8] := slot_top[8] + piece_half_size;
     slot_y_center[9] := slot_top[9] + piece_half_size;
     slot_y_center[10] := slot_top[10] + piece_half_size;
     slot_y_center[11] := slot_top[11] + piece_half_size;
     slot_y_center[12] := slot_top[12] + piece_half_size;



     board_border_x_center[0] := slot_x_center[4];
     board_border_x_center[1] := slot_x_center[5];
     board_border_x_center[2] := slot_x_center[6];
     board_border_x_center[3] := slot_x_center[7];
     board_border_x_center[4] := slot_x_center[8];

     board_border_x_center[5] := slot_x_center[5] - 2*x_distance_between_slots;
     board_border_x_center[6] := slot_x_center[8] + x_distance_between_slots;

     board_border_x_center[7] := slot_x_center[0] - x_distance_between_slots;
     board_border_x_center[8] := slot_x_center[0] - x_distance_between_slots;

     board_border_x_center[9] := slot_x_center[3] + x_distance_between_slots;
     board_border_x_center[10] := slot_x_center[3] + x_distance_between_slots;



     board_border_y_center[0] := slot_y_center[4] - 2*y_distance_between_slots;
     board_border_y_center[1] := slot_y_center[5] - 2*y_distance_between_slots;
     board_border_y_center[2] := slot_y_center[6] - 2*y_distance_between_slots;
     board_border_y_center[3] := slot_y_center[7] - 2*y_distance_between_slots;
     board_border_y_center[4] := slot_y_center[8] - 2*y_distance_between_slots;

     board_border_y_center[5] := slot_y_center[5];
     board_border_y_center[6] := slot_y_center[8];

     board_border_y_center[7] := slot_y_center[0];
     board_border_y_center[8] := slot_y_center[0] + 2*y_distance_between_slots;

     board_border_y_center[9] := slot_y_center[3];
     board_border_y_center[10] := slot_y_center[3] + 2*y_distance_between_slots;



     board_border_x_center[11] := slot_x_center[4];
     board_border_x_center[12] := slot_x_center[5];
     board_border_x_center[13] := slot_x_center[6];
     board_border_x_center[14] := slot_x_center[7];
     board_border_x_center[15] := slot_x_center[8];

     board_border_y_center[11] := slot_y_center[4] + 2*y_distance_between_slots;
     board_border_y_center[12] := slot_y_center[5] + 2*y_distance_between_slots;
     board_border_y_center[13] := slot_y_center[6] + 2*y_distance_between_slots;
     board_border_y_center[14] := slot_y_center[7] + 2*y_distance_between_slots;
     board_border_y_center[15] := slot_y_center[8] + 2*y_distance_between_slots;

        //=========================



   board_image := TBGRABitmap.Create(gApp.Screen.WH.Width, gApp.Screen.WH.Height);


   //board_image.Canvas.Pen.Color := clRed;
   //board_image.Canvas.Ellipse(current_piece_marking_ellipse_rect);


   // https://forum.lazarus.freepascal.org/index.php?topic=45210.0
   //board_image.Fill... // all drawing stuff into persistent Bitmap, anywhere in the code

   //board_image.Canvas.Brush.Style := bsClear;
   //board_image.Canvas.Brush.Color := clNone;

   board_image.Canvas.Pen.Color := clGray;
   //Bitmap.Canvas.Pen.Style := psClear;

   board_image.Canvas.Pen.Width := 2;



   //https://forum.lazarus.freepascal.org/index.php?topic=45210.0
   board_image.FillTransparent;
   //board_image.PutImage(0, 0, board_image, dmDrawWithTransparency); // OnRedraw event
   //board_image.Rectangle(10, 10, 100, 100, BGRABlack, BGRAPixelTransparent, dmDrawWithTransparency);
   //board_image.EllipseAntialias(100, 100, 50, 50, BGRABlack, 1, BGRAPixelTransparent);


   board_image.EllipseAntialias(slot_x_center[0], slot_y_center[0] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[1], slot_y_center[1] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[2], slot_y_center[2] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[3], slot_y_center[3] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[4], slot_y_center[4] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[5], slot_y_center[5] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[6], slot_y_center[6] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[7], slot_y_center[7] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[8], slot_y_center[8] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[9], slot_y_center[9] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[10], slot_y_center[10] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[11], slot_y_center[11] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);
   board_image.EllipseAntialias(slot_x_center[12], slot_y_center[12] - board_offset_y_for_table_draw, piece_quarter_size, piece_quarter_size, BGRABlack, 1, BGRAPixelTransparent);



   //procedure Arc(cx,cy,rx,ry: single; const StartPoint,EndPoint: TPointF; AColor: TBGRAPixel; width: Single; ADrawChord: boolean; AFillColor: TBGRAPixel); overload;



   board_image.Arc(board_border_x_center[0], board_border_y_center[0] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,-Pi*0.68, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[1], board_border_y_center[1] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,-Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[2], board_border_y_center[2] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,-Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[3], board_border_y_center[3] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,-Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[4], board_border_y_center[4] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, -Pi, -Pi*0.35, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[5], board_border_y_center[5] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.35, -Pi*0.35, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[6], board_border_y_center[6] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.68, Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[6], board_border_y_center[6] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, -Pi*0.68, -Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[7], board_border_y_center[7] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.35, -Pi*0.68, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[8], board_border_y_center[8] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.68, -Pi*0.35, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[9], board_border_y_center[9] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.68, Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[9], board_border_y_center[9] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, -Pi*0.35, -Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[10], board_border_y_center[10] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi*0.35, Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[10], board_border_y_center[10] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, -Pi*0.68, -Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);

   board_image.Arc(board_border_x_center[11], board_border_y_center[11] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,Pi*0.68, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[12], board_border_y_center[12] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[13], board_border_y_center[13] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[14], board_border_y_center[14] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, 0,Pi, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);
   board_image.Arc(board_border_x_center[15], board_border_y_center[15] - board_offset_y_for_table_draw, board_border_radius, board_border_radius, Pi,Pi*0.35, board_border_color, board_border_pen_width, false, BGRAPixelTransparent);



   CopyFilesFromAssetsToInternalDirectory();


   CreatePieceBitmaps();

   StartNewGame();




end;

procedure TPuzzleGameForm.PuzzleGameFormRequestPermissionResult(
  Sender: TObject; requestCode: integer; manifestPermission: string;
  grantResult: TManifestPermissionResult);
begin

  case requestCode of
   6001:begin
            if grantResult = PERMISSION_GRANTED  then
//              ShowMessage(manifestPermission + LineEnding + 'permission granted.' )
            else  //PERMISSION_DENIED

              // if (targetSdkPlatform < 29)
              //ShowMessage(manifestPermission + LineEnding + 'permission denied.' );
        end;
  end;

end;

procedure TPuzzleGameForm.PuzzleGameFormRotate(Sender: TObject;
  rotate: TScreenStyle);
begin

    Self.UpdateLayout;

end;

procedure TPuzzleGameForm.PuzzleGameFormShow(Sender: TObject);
begin

    Ratio := jBitmap1.GetRatio;

//    CopyFilesFromAssetsTimer.Enabled := true;


end;

procedure TPuzzleGameForm.PuzzleGameFormSpecialKeyDown(Sender: TObject;
  keyChar: char; keyCode: integer; keyCodeString: string; var mute: boolean);
begin


// ShowMessage('SpecialKeyDown');
// ShowMessage(keyCodeString);

// https://www.kansoftware.ru/?tid=13041
// Delphi Android:
// if Key = vkHardwareBack then
// Key := 0;

// https://lazarus-ccr.sourceforge.io/docs/lcl/lcltype/index-2.html
// VK_BACK Virtual key code for the Backspace key.
// Not to be confused with the Android BACK navigation key which is mapped to VK_ESCAPE


//if (keyCodeString = 'KEYCODE_BACK') then
if (keyCode = 4) then  // KEYCODE_BACK
begin

  if(can_close = true) then
  begin
    mute := false; //close app
  end
  else
  begin
    mute := true; //do not close app

    combobox_item_selected := PlayerSelectComboBox.GetSelectedIndex() - 2;
    if((combobox_item_selected >= 0) and (on_app_start_combobox_item_selected <> combobox_item_selected)) then
    begin
      // ShowMessage('Writing default player changed ...');
      player_names_stringlist.Strings[0] := IntToStr(combobox_item_selected);
      player_names_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + 'puzzle_game_players.txt');
    end;

    merge_solution_mode := 0;
    jDialogYN1.Msg := 'Do you really want to exit Kwazy Quilt Puzzle No. 7114?';
    jDialogYN1.Title := 'Exit game';
    jDialogYN1.Show();
  end;

end; // if keyCode = 4 then  //KEYCODE_BACK



end;


procedure TPuzzleGameForm.RateAppButtonClick(Sender: TObject);
begin



  //jIntentManager1.SetAction(iaView);  //or 'android.intent.action.VIEW' // <<--- important to set

  if(app_store = GOOGLE_STORE) then
  begin
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  //jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://play.google.com/store/apps/details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end
  else if(app_store = SAMSUNG_STORE) then
  begin
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('samsungapps://AppRating/com.cognaxon.KwazyQuiltPuzzleNo7114'));
  // jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://apps.samsung.com/appquery/AppRating.as?appId=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end
  else if(app_store = HUAWEI_STORE) then
  begin
  //jIntentManager1.SetDataUri(jIntentManager1.ParseUri('appmarket://details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://appgallery.cloud.huawei.com/appDetail?pkgName=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end
  else if(app_store = XIAOMI_STORE) then
  begin
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://global.app.mi.com/details?lo=TR&la=en_US&id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end
  else if(app_store = AMAZON_STORE) then
  begin
  //jIntentManager1.SetDataUri(jIntentManager1.ParseUri('amzn://apps/android?p=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://www.amazon.com/gp/mas/dl/android?p=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end
  else
  begin
  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://play.google.com/store/apps/details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
  end;



  jIntentManager1.StartActivity();


  //jIntentManager1.SetAction(iaView);  //or 'android.intent.action.VIEW'

  {
  try
    try
      //jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://search?q=pname:'+'com.google.android.camera')); //works
      jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
    except
    on E: Exception do
      jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://play.google.com/store/apps/details?id=com.cognaxon.KwazyQuiltPuzzleNo7114'));
    end;
  finally
    jIntentManager1.StartActivity();
  end;
  }

end;

procedure TPuzzleGameForm.Rot60MinusButtonClick(Sender: TObject);
begin

  if(slideshow_mode = true) then
  begin
  LoadNextSolution(-1);
  Exit();
  end;


  if(MoveToNearestSlotAnimationTimer.Enabled = true) then // workaround solution for: while piece is moving, click outside board and piece disappears.
  Exit();

  TableView.Enabled := false;
  FlipButton.Enabled := false;
  Rot60PlusButton.Enabled := false;
  Rot60MinusButton.Enabled := false;



  if(current_piece < 1) then
  current_piece := saved_current_piece;

  if(current_piece < 1) then
  begin
  ShowMessage('Please select piece for rotation');
  Exit();
  end;


  if(current_piece > 0) then // Android Fix begin
  final_rotation_angle := piece_rotation_angle[current_piece-1]
  else
  final_rotation_angle := 0;



  if(piece_is_flipped[current_piece-1] = false) then
  begin
  final_rotation_angle := final_rotation_angle - 60;
  if(final_rotation_angle < 0) then
  final_rotation_angle := 300;
  end
  else
  begin
  final_rotation_angle := final_rotation_angle + 60;
  if(final_rotation_angle >= 360) then
  final_rotation_angle := 0;
  end;



  if(current_piece > 0) then // Android Fix begin
  piece_rotation_angle[current_piece-1] := final_rotation_angle;
  PlacePieceIntoBoardToFindCollisions(current_piece, current_slot);
  date_and_time_string := '';


//  ShowMessage('rotation angle = ' + IntToStr(final_rotation_angle));

  RotatePiece();

  previous_current_piece := 0;
  //if((current_piece > 0) and (previous_current_piece <> current_piece)) then
  TableView.Refresh();


  if (MoveToNearestSlotAnimationTimer.Enabled = false) then
  begin
    TableView.Enabled := true;
    FlipButton.Enabled := true;
    Rot60PlusButton.Enabled := true;
    Rot60MinusButton.Enabled := true;
  end;

end;

procedure TPuzzleGameForm.Rot60PlusButtonClick(Sender: TObject);
begin


  if(slideshow_mode = true) then
  begin
  LoadNextSolution(1);
  Exit();
  end;


  if(MoveToNearestSlotAnimationTimer.Enabled = true) then // workaround solution for: while piece is moving, click outside board and piece disappears.
  Exit();

  TableView.Enabled := false;
  FlipButton.Enabled := false;
  Rot60PlusButton.Enabled := false;
  Rot60MinusButton.Enabled := false;


  if(current_piece < 1) then
  current_piece := saved_current_piece;

  if(current_piece < 1) then
  begin
  ShowMessage('Please select piece for rotation');
  Exit();
  end;


  if(current_piece > 0) then // Android Fix begin
  final_rotation_angle := piece_rotation_angle[current_piece-1]
  else
  final_rotation_angle := 0;



  if(piece_is_flipped[current_piece-1] = false) then
  begin
  final_rotation_angle := final_rotation_angle + 60;
  if(final_rotation_angle >= 360) then
  final_rotation_angle := 0;
  end
  else
  begin
  final_rotation_angle := final_rotation_angle - 60;
  if(final_rotation_angle < 0) then
  final_rotation_angle := 300;
  end;



  if(current_piece > 0) then // Android Fix begin
  piece_rotation_angle[current_piece-1] := final_rotation_angle;
  PlacePieceIntoBoardToFindCollisions(current_piece, current_slot);
  date_and_time_string := '';


//  ShowMessage('rotation angle = ' + IntToStr(final_rotation_angle));

  RotatePiece();

  previous_current_piece := 0;
  //if((current_piece > 0) and (previous_current_piece <> current_piece)) then
  TableView.Refresh();


  if (MoveToNearestSlotAnimationTimer.Enabled = false) then
  begin
    TableView.Enabled := true;
    FlipButton.Enabled := true;
    Rot60PlusButton.Enabled := true;
    Rot60MinusButton.Enabled := true;
  end;

end;


procedure TPuzzleGameForm.RotatePiece();
begin




    if(current_piece > 0) then // Android Fix begin
    final_rotation_angle := piece_rotation_angle[current_piece-1]
    else
    final_rotation_angle := 0;



    if (current_piece = 1) then
    piece01BitmapRotated.SetImage(jBitmap1.Rotate(piece01Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 2) then
    piece02BitmapRotated.SetImage(jBitmap1.Rotate(piece02Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 3) then
    piece03BitmapRotated.SetImage(jBitmap1.Rotate(piece03Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 4) then
    piece04BitmapRotated.SetImage(jBitmap1.Rotate(piece04Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 5) then
    piece05BitmapRotated.SetImage(jBitmap1.Rotate(piece05Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 6) then
    piece06BitmapRotated.SetImage(jBitmap1.Rotate(piece06Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 7) then
    piece07BitmapRotated.SetImage(jBitmap1.Rotate(piece07Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 8) then
    piece08BitmapRotated.SetImage(jBitmap1.Rotate(piece08Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 9) then
    piece09BitmapRotated.SetImage(jBitmap1.Rotate(piece09Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 10) then
    piece10BitmapRotated.SetImage(jBitmap1.Rotate(piece10Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 11) then
    piece11BitmapRotated.SetImage(jBitmap1.Rotate(piece11Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 12) then
    piece12BitmapRotated.SetImage(jBitmap1.Rotate(piece12Bitmap.GetImage(), Single(final_rotation_angle)))
    else if (current_piece = 13) then
    piece13BitmapRotated.SetImage(jBitmap1.Rotate(piece13Bitmap.GetImage(), Single(final_rotation_angle)));

//    piece13BitmapRotated.SetImage(jBitmap1.AntiClockWise(piece13Bitmap.GetImage())); // works, testing only



    if ((current_piece = 1) and (piece_is_flipped[current_piece-1] = true)) then
    piece01BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece01BitmapRotated.GetImage()))
    else if ((current_piece = 2) and (piece_is_flipped[current_piece-1] = true)) then
    piece02BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece02BitmapRotated.GetImage()))
    else if ((current_piece = 3) and (piece_is_flipped[current_piece-1] = true)) then
    piece03BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece03BitmapRotated.GetImage()))
    else if ((current_piece = 4) and (piece_is_flipped[current_piece-1] = true)) then
    piece04BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece04BitmapRotated.GetImage()))
    else if ((current_piece = 5) and (piece_is_flipped[current_piece-1] = true)) then
    piece05BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece05BitmapRotated.GetImage()))
    else if ((current_piece = 6) and (piece_is_flipped[current_piece-1] = true)) then
    piece06BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece06BitmapRotated.GetImage()))
    else if ((current_piece = 7) and (piece_is_flipped[current_piece-1] = true)) then
    piece07BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece07BitmapRotated.GetImage()))
    else if ((current_piece = 8) and (piece_is_flipped[current_piece-1] = true)) then
    piece08BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece08BitmapRotated.GetImage()))
    else if ((current_piece = 9) and (piece_is_flipped[current_piece-1] = true)) then
    piece09BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece09BitmapRotated.GetImage()))
    else if ((current_piece = 10) and (piece_is_flipped[current_piece-1] = true)) then
    piece10BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece10BitmapRotated.GetImage()))
    else if ((current_piece = 11) and (piece_is_flipped[current_piece-1] = true)) then
    piece11BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece11BitmapRotated.GetImage()))
    else if ((current_piece = 12) and (piece_is_flipped[current_piece-1] = true)) then
    piece12BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece12BitmapRotated.GetImage()))
    else if ((current_piece = 13) and (piece_is_flipped[current_piece-1] = true)) then
    piece13BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece13BitmapRotated.GetImage()));






end;



procedure TPuzzleGameForm.TabLayout1TabSelected(Sender: TObject;
  position: integer; title: string);
begin

  if position = 0 then
  begin

  if (slideshow_mode = false) then
  begin
  ShowSavedSolutionsButton.Visible := false;
  FlipButton.Text := 'Flip';
  Rot60MinusButton.Text := 'Rotate -60';
  Rot60PlusButton.Text := 'Rotate +60';
  end
  else
  begin
  ShowSavedSolutionsButton.Visible := true;
  FlipButton.Text := 'Pause';
  Rot60MinusButton.Text := '<';
  Rot60PlusButton.Text := '>';
  end;

  TableView.Visible := true;
  FlipButton.Visible := true;
  Rot60PlusButton.Visible := true;
  Rot60MinusButton.Visible := true;

  NewGameButton.Visible := false;
  PlayerSelectComboBox.Visible := false;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;
  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;

  PieceRotationTrackBar.Visible := false; // z-order of TableView hides PieceRotationTrackBar
  FixButton.Visible := false;
  OutputLabel.Visible := false; // OutputLabel is covered by TableView, does not work in Android
  DateLabel.Visible := false;  // DateLabel is covered by TableView, does not work in Android
  DebugLabel.Visible := false;

  MoreAppsButton.Visible := false;
  RateAppButton.Visible := false;
  OtherPlatformsButton.Visible := false;
  AboutWebView.Visible := false;
  end

  else if position = 1 then
  begin


  if(player_names_loaded = 0) then
  LoadPlayerNames();

  TableView.Visible := false;
  FlipButton.Visible := false;
  Rot60PlusButton.Visible := false;
  Rot60MinusButton.Visible := false;

  NewGameButton.Visible := true;
  ShowSavedSolutionsButton.Visible := true;
  PlayerSelectComboBox.Visible := true;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;
  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := true;
  ImportSavedSolutionsButton.Visible := true;

  PieceRotationTrackBar.Visible := false; // z-order of TableView hides PieceRotationTrackBar
  FixButton.Visible := false;
  OutputLabel.Visible := false; // OutputLabel is covered by TableView, does not work in Android
  DateLabel.Visible := false;  // DateLabel is covered by TableView, does not work in Android
  DebugLabel.Visible := false;

  MoreAppsButton.Visible := false;
  RateAppButton.Visible := false;
  OtherPlatformsButton.Visible := false;
  AboutWebView.Visible := false;
  end

  else if position = 2 then
  begin
  TableView.Visible := false;
  FlipButton.Visible := false;
  Rot60PlusButton.Visible := false;
  Rot60MinusButton.Visible := false;

  NewGameButton.Visible := false;
  ShowSavedSolutionsButton.Visible := false;
  PlayerSelectComboBox.Visible := false;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;
  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;

  PieceRotationTrackBar.Visible := false; // z-order of TableView hides PieceRotationTrackBar
  FixButton.Visible := false;
  OutputLabel.Visible := false;
  DateLabel.Visible := false;
  DebugLabel.Visible := false;

  MoreAppsButton.Visible := true;
  RateAppButton.Visible := true;
  OtherPlatformsButton.Visible := true;
  AboutWebView.Visible := true;
  end;


end;


procedure TPuzzleGameForm.CreatePieceBitmaps();
begin


  board_image.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, board_image);
      BoardBitmap.LoadFromStream(memory_stream);
    finally
      memory_stream.Free;
    end;
  finally
      png_writer.Free;
  end;


  jBitmap1.ImageIndex := 0;
  piece01Bitmap.SetImage(jBitmap1.GetImage());
  piece01BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 1;
  piece02Bitmap.SetImage(jBitmap1.GetImage());
  piece02BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 2;
  piece03Bitmap.SetImage(jBitmap1.GetImage());
  piece03BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 3;
  piece04Bitmap.SetImage(jBitmap1.GetImage());
  piece04BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 4;
  piece05Bitmap.SetImage(jBitmap1.GetImage());
  piece05BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 5;
  piece06Bitmap.SetImage(jBitmap1.GetImage());
  piece06BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 6;
  piece07Bitmap.SetImage(jBitmap1.GetImage());
  piece07BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 7;
  piece08Bitmap.SetImage(jBitmap1.GetImage());
  piece08BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 8;
  piece09Bitmap.SetImage(jBitmap1.GetImage());
  piece09BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 9;
  piece10Bitmap.SetImage(jBitmap1.GetImage());
  piece10BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 10;
  piece11Bitmap.SetImage(jBitmap1.GetImage());
  piece11BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 11;
  piece12Bitmap.SetImage(jBitmap1.GetImage());
  piece12BitmapRotated.SetImage(jBitmap1.GetImage());

  jBitmap1.ImageIndex := 12;
  piece13Bitmap.SetImage(jBitmap1.GetImage());
  piece13BitmapRotated.SetImage(jBitmap1.GetImage());


end;


procedure TPuzzleGameForm.CreatePieceBitmapsTBGRABitmap();
begin

// Function works, but it is not used by program. Program uses equivalent function CreatePieceBitmaps


    board_image.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, board_image);
        BoardBitmap.LoadFromStream(memory_stream);
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_01.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_01);
        piece01Bitmap.LoadFromStream(memory_stream);
        piece01BitmapRotated.SetImage(piece01Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_02.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_02);
        piece02Bitmap.LoadFromStream(memory_stream);
        piece02BitmapRotated.SetImage(piece02Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_03.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_03);
        piece03Bitmap.LoadFromStream(memory_stream);
        piece03BitmapRotated.SetImage(piece03Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_04.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_04);
        piece04Bitmap.LoadFromStream(memory_stream);
        piece04BitmapRotated.SetImage(piece04Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_05.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_05);
        piece05Bitmap.LoadFromStream(memory_stream);
        piece05BitmapRotated.SetImage(piece05Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_06.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_06);
        piece06Bitmap.LoadFromStream(memory_stream);
        piece06BitmapRotated.SetImage(piece06Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;




    piece_image_07.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_07);
        piece07Bitmap.LoadFromStream(memory_stream);
        piece07BitmapRotated.SetImage(piece07Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;




    piece_image_08.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_08);
        piece08Bitmap.LoadFromStream(memory_stream);
        piece08BitmapRotated.SetImage(piece08Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;




    piece_image_09.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_09);
        piece09Bitmap.LoadFromStream(memory_stream);
        piece09BitmapRotated.SetImage(piece09Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_10.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_10);
        piece10Bitmap.LoadFromStream(memory_stream);
        piece10BitmapRotated.SetImage(piece10Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_11.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_11);
        piece11Bitmap.LoadFromStream(memory_stream);
        piece11BitmapRotated.SetImage(piece11Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;




    piece_image_12.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_12);
        piece12Bitmap.LoadFromStream(memory_stream);
        piece12BitmapRotated.SetImage(piece12Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



    piece_image_13.InvalidateBitmap;
    png_writer := TFPWriterPNG.Create;
    try
      memory_stream := TMemoryStream.Create;
      try
        TFPWriterPNG(png_writer).UseAlpha := true;
        png_writer.ImageWrite(memory_stream, piece_image_13);
        piece13Bitmap.LoadFromStream(memory_stream);
        piece13BitmapRotated.SetImage(piece13Bitmap.GetImage());
      finally
        memory_stream.Free;
      end;
    finally
      png_writer.Free;
    end;



end;


procedure TPuzzleGameForm.DrawBackgroundOfBoard();
begin


  if(previous_current_piece = current_piece) then
  Exit();


     //TableView.Canvas.PaintColor:= colbrGreen;
    //TableView.Canvas.PaintStyle:= psFillAndStroke;
    //TableView.Canvas.PaintTextSize:= 20;
    //TableView.Canvas.drawBitmap(jBitmap1,10,10, TableView.Width-20,Round( (TableView.Width-20)*(1/Ratio) ) );
    //TableView.Canvas.drawBitmap(jBitmap1,10,10, TableView.Width, Ratio);

    (*
    jBitmap1.ImageIndex := 0;
    TableView.Canvas.drawBitmap(jBitmap1.GetImage(), 0, 0, 100, 100);  // veikia

    jBitmap1.ImageIndex := 1;
    TableView.Canvas.drawBitmap(jBitmap1.GetImage(), 0, 100, 100, 200);  // veikia
     *)

  // C:\fpcupdeluxe\ccr\lamw\android_bridges\Laz_And_Controls.pas
  // jCanvas = class(jControl)

  // procedure DrawBitmap(bmp: jObject; b, l, r, t: integer); overload;  // b l r t  <-- incorrect names, must be l b r t
  // procedure DrawBitmap(_bitmap: jObject; _width: integer; _height: integer); overload;
  // procedure DrawBitmap(bmp: jObject; x1, y1, size: integer; ratio: single); overload;
  // procedure DrawBitmap(bmp: jBitmap; x1, y1, size: integer; ratio: single); overload;
  // procedure DrawBitmap(bmp: jBitmap; b, l, r, t: integer); overload;
  // procedure DrawBitmap(_left: single; _top: single; _bitmap: jObject); overload;

  BackgroundCanvas.Clear(colbrWhite);


  //ReceptiveFieldCanvas.SetBitmap(jBitmap1.GetImage());
  // TableView.SetImage(jBitmap1.GetImage());
  //TableView.Canvas.drawBitmap(BoardBitmap.GetImage(), 0, 0, gApp.Screen.WH.Width, gApp.Screen.WH.Height);  // b l r t  <-- incorrect names, must be l b r t
  BackgroundCanvas.drawBitmap(BoardBitmap.GetImage(), 0, 0, gApp.Screen.WH.Width, gApp.Screen.WH.Height);  // b l r t  <-- incorrect names, must be l b r t





  if(current_piece <> 1) then
  begin
    //piece01_left := 0;
    //piece01_top := piece01_bottom + piece01_height;
    piece01_bottom := piece01_top - piece01_height;
    piece01_right := piece01_left + piece01_width;

    //ReceptiveFieldCanvas.SetBitmap(jBitmap1.GetImage());
    // TableView.SetImage(jBitmap1.GetImage());
    //TableView.Canvas.drawBitmap(piece01BitmapRotated.GetImage(), piece01_left, piece01_bottom, piece01_right, piece01_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece01BitmapRotated.GetImage(), piece01_left, piece01_bottom, piece01_right, piece01_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 1) then

  if(current_piece <> 2) then
  begin
    piece02_bottom := piece02_top - piece02_height;
    piece02_right := piece02_left + piece02_width;

    //TableView.Canvas.drawBitmap(piece02BitmapRotated.GetImage(), piece02_left, piece02_bottom, piece02_right, piece02_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece02BitmapRotated.GetImage(), piece02_left, piece02_bottom, piece02_right, piece02_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 2) then


  if(current_piece <> 3) then
  begin
    piece03_bottom := piece03_top - piece03_height;
    piece03_right := piece03_left + piece03_width;

    //TableView.Canvas.drawBitmap(piece03BitmapRotated.GetImage(), piece03_left, piece03_bottom, piece03_right, piece03_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece03BitmapRotated.GetImage(), piece03_left, piece03_bottom, piece03_right, piece03_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 3) then

  if(current_piece <> 4) then
  begin
    piece04_bottom := piece04_top - piece04_height;
    piece04_right := piece04_left + piece04_width;

    //TableView.Canvas.drawBitmap(piece04BitmapRotated.GetImage(), piece04_left, piece04_bottom, piece04_right, piece04_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece04BitmapRotated.GetImage(), piece04_left, piece04_bottom, piece04_right, piece04_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 4) then

  if(current_piece <> 5) then
  begin
    piece05_bottom := piece05_top - piece05_height;
    piece05_right := piece05_left + piece05_width;

    //TableView.Canvas.drawBitmap(piece05BitmapRotated.GetImage(), piece05_left, piece05_bottom, piece05_right, piece05_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece05BitmapRotated.GetImage(), piece05_left, piece05_bottom, piece05_right, piece05_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 5) then


  if(current_piece <> 6) then
  begin
    piece06_bottom := piece06_top - piece06_height;
    piece06_right := piece06_left + piece06_width;

    //TableView.Canvas.drawBitmap(piece06BitmapRotated.GetImage(), piece06_left, piece06_bottom, piece06_right, piece06_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece06BitmapRotated.GetImage(), piece06_left, piece06_bottom, piece06_right, piece06_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 6) then


  if(current_piece <> 7) then
  begin
    piece07_bottom := piece07_top - piece07_height;
    piece07_right := piece07_left + piece07_width;

    //TableView.Canvas.drawBitmap(piece07BitmapRotated.GetImage(), piece07_left, piece07_bottom, piece07_right, piece07_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece07BitmapRotated.GetImage(), piece07_left, piece07_bottom, piece07_right, piece07_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 7) then


  if(current_piece <> 8) then
  begin
    piece08_bottom := piece08_top - piece08_height;
    piece08_right := piece08_left + piece08_width;

    //TableView.Canvas.drawBitmap(piece08BitmapRotated.GetImage(), piece08_left, piece08_bottom, piece08_right, piece08_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece08BitmapRotated.GetImage(), piece08_left, piece08_bottom, piece08_right, piece08_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 8) then


  if(current_piece <> 9) then
  begin
    piece09_bottom := piece09_top - piece09_height;
    piece09_right := piece09_left + piece09_width;

    //TableView.Canvas.drawBitmap(piece09BitmapRotated.GetImage(), piece09_left, piece09_bottom, piece09_right, piece09_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece09BitmapRotated.GetImage(), piece09_left, piece09_bottom, piece09_right, piece09_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 9) then


  if(current_piece <> 10) then
  begin
    piece10_bottom := piece10_top - piece10_height;
    piece10_right := piece10_left + piece10_width;

    //TableView.Canvas.drawBitmap(piece10BitmapRotated.GetImage(), piece10_left, piece10_bottom, piece10_right, piece10_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece10BitmapRotated.GetImage(), piece10_left, piece10_bottom, piece10_right, piece10_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 10) then


  if(current_piece <> 11) then
  begin
    piece11_bottom := piece11_top - piece11_height;
    piece11_right := piece11_left + piece11_width;

    //TableView.Canvas.drawBitmap(piece11BitmapRotated.GetImage(), piece11_left, piece11_bottom, piece11_right, piece11_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece11BitmapRotated.GetImage(), piece11_left, piece11_bottom, piece11_right, piece11_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 11) then


  if(current_piece <> 12) then
  begin
    piece12_bottom := piece12_top - piece12_height;
    piece12_right := piece12_left + piece12_width;

    //TableView.Canvas.drawBitmap(piece12BitmapRotated.GetImage(), piece12_left, piece12_bottom, piece12_right, piece12_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece12BitmapRotated.GetImage(), piece12_left, piece12_bottom, piece12_right, piece12_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 12) then


  if(current_piece <> 13) then
  begin
    piece13_bottom := piece13_top - piece13_height;
    piece13_right := piece13_left + piece13_width;

    //TableView.Canvas.drawBitmap(piece13BitmapRotated.GetImage(), piece13_left, piece13_bottom, piece13_right, piece13_top);  // b l r t  <-- incorrect names, must be l b r t
    BackgroundCanvas.drawBitmap(piece13BitmapRotated.GetImage(), piece13_left, piece13_bottom, piece13_right, piece13_top);  // b l r t  <-- incorrect names, must be l b r t
  end; // if(current_piece <> 13) then


  //TableView.Canvas.PaintColor := colbrWhite;
  //TableView.Canvas.PaintStyle := psFill;
  //TableView.Canvas.DrawBitmap(0,0, BackgroundCanvas.GetBitmap());


end;





procedure TPuzzleGameForm.RedrawCurrentPiece();
begin

//  if(slideshow_mode = true) then
//  begin
//   DrawBackgroundOfBoard();
//  end;


  if(redraw_current_piece_finished = 0) then
  Exit();

  redraw_current_piece_finished := 0;



  if (background_of_board_already_drawn = 0) then
  begin
    DrawBackgroundOfBoard();
    background_of_board_already_drawn := 1;
  end;


  if((current_piece > 0) and (previous_current_piece <> current_piece)) then
  //if(previous_current_piece <> current_piece) then
  begin
  DrawBackgroundOfBoard();
  DebugLabel.Text := 'piece = ' + IntToStr(current_piece);
//  ShowMessage('piece = ' + IntToStr(current_piece));
  end;




  TableView.Canvas.PaintColor := colbrWhite; // colbrDefault = transparent, colbrWhite
  TableView.Canvas.PaintStyle := psFill;
//  TableView.Canvas.PaintStrokeWidth := 20.0;
//  TableView.Canvas.DrawBitmap(0,0, BackgroundCanvas.GetBitmap());
//  TableCanvas.PaintColor := colbrWhite; // colbrDefault = transparent, colbrWhite
//  TableCanvas.PaintStyle := psFill;
  TableCanvas.DrawBitmap(0,0, BackgroundCanvas.GetBitmap());


  if(current_piece = 1) then
  begin
  //piece01_left := 0;
  //piece01_top := piece01_bottom + piece01_height;
    piece01_bottom := piece01_top - piece01_height;
    piece01_right := piece01_left + piece01_width;

    TableView.Canvas.drawBitmap(piece01BitmapRotated.GetImage(), piece01_left, piece01_bottom, piece01_right, piece01_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece01_left+piece_half_size, piece01_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 1) then

  if(current_piece = 2) then
  begin
    piece02_bottom := piece02_top - piece02_height;
    piece02_right := piece02_left + piece02_width;

    TableView.Canvas.drawBitmap(piece02BitmapRotated.GetImage(), piece02_left, piece02_bottom, piece02_right, piece02_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece02_left+piece_half_size, piece02_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 2) then


  if(current_piece = 3) then
  begin
    piece03_bottom := piece03_top - piece03_height;
    piece03_right := piece03_left + piece03_width;

    TableView.Canvas.drawBitmap(piece03BitmapRotated.GetImage(), piece03_left, piece03_bottom, piece03_right, piece03_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece03_left+piece_half_size, piece03_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 3) then

  if(current_piece = 4) then
  begin
    piece04_bottom := piece04_top - piece04_height;
    piece04_right := piece04_left + piece04_width;

    TableView.Canvas.drawBitmap(piece04BitmapRotated.GetImage(), piece04_left, piece04_bottom, piece04_right, piece04_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece04_left+piece_half_size, piece04_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 4) then

  if(current_piece = 5) then
  begin
    piece05_bottom := piece05_top - piece05_height;
    piece05_right := piece05_left + piece05_width;

    TableView.Canvas.drawBitmap(piece05BitmapRotated.GetImage(), piece05_left, piece05_bottom, piece05_right, piece05_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece05_left+piece_half_size, piece05_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 5) then


  if(current_piece = 6) then
  begin
    piece06_bottom := piece06_top - piece06_height;
    piece06_right := piece06_left + piece06_width;

   TableView.Canvas.drawBitmap(piece06BitmapRotated.GetImage(), piece06_left, piece06_bottom, piece06_right, piece06_top);  // b l r t  <-- incorrect names, must be l b r t
   if(slideshow_mode = false) then
   TableView.Canvas.DrawCircle(piece06_left+piece_half_size, piece06_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 6) then


  if(current_piece = 7) then
  begin
    piece07_bottom := piece07_top - piece07_height;
    piece07_right := piece07_left + piece07_width;

    TableView.Canvas.drawBitmap(piece07BitmapRotated.GetImage(), piece07_left, piece07_bottom, piece07_right, piece07_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece07_left+piece_half_size, piece07_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 7) then


  if(current_piece = 8) then
  begin
    piece08_bottom := piece08_top - piece08_height;
    piece08_right := piece08_left + piece08_width;

    TableView.Canvas.drawBitmap(piece08BitmapRotated.GetImage(), piece08_left, piece08_bottom, piece08_right, piece08_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece08_left+piece_half_size, piece08_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 7) then


  if(current_piece = 9) then
  begin
    piece09_bottom := piece09_top - piece09_height;
    piece09_right := piece09_left + piece09_width;

    TableView.Canvas.drawBitmap(piece09BitmapRotated.GetImage(), piece09_left, piece09_bottom, piece09_right, piece09_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece09_left+piece_half_size, piece09_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 9) then


  if(current_piece = 10) then
  begin
    piece10_bottom := piece10_top - piece10_height;
    piece10_right := piece10_left + piece10_width;

    TableView.Canvas.drawBitmap(piece10BitmapRotated.GetImage(), piece10_left, piece10_bottom, piece10_right, piece10_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece10_left+piece_half_size, piece10_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 10) then


  if(current_piece = 11) then
  begin
    piece11_bottom := piece11_top - piece11_height;
    piece11_right := piece11_left + piece11_width;

    TableView.Canvas.drawBitmap(piece11BitmapRotated.GetImage(), piece11_left, piece11_bottom, piece11_right, piece11_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece11_left+piece_half_size, piece11_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 11) then


  if(current_piece = 12) then
  begin
    piece12_bottom := piece12_top - piece12_height;
    piece12_right := piece12_left + piece12_width;

    TableView.Canvas.drawBitmap(piece12BitmapRotated.GetImage(), piece12_left, piece12_bottom, piece12_right, piece12_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece12_left+piece_half_size, piece12_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 12) then


  if(current_piece = 13) then
  begin
    piece13_bottom := piece13_top - piece13_height;
    piece13_right := piece13_left + piece13_width;

    TableView.Canvas.drawBitmap(piece13BitmapRotated.GetImage(), piece13_left, piece13_bottom, piece13_right, piece13_top);  // b l r t  <-- incorrect names, must be l b r t
    if(slideshow_mode = false) then
    TableView.Canvas.DrawCircle(piece13_left+piece_half_size, piece13_top-piece_half_size, current_piece_marking_ellipse_radius);
  end; // if(current_piece = 13) then


  if(error_circle_image_visible = 1) then
  begin
    TableView.Canvas.PaintColor := colbrRed; // colbrDefault = transparent, colbrWhite
    TableView.Canvas.PaintStyle := psFill;
//  TableView.Canvas.PaintStrokeWidth := 20.0;
    TableView.Canvas.DrawCircle(error_circle_image_left+current_piece_marking_ellipse_radius, error_circle_image_top-current_piece_marking_ellipse_radius, current_piece_marking_ellipse_radius);

//   error_circle_image_left
//   error_circle_image_top
//   current_piece_marking_ellipse_radius
//   error_circle_pen_width_div_2
  end;


// DrawTextAligned(_text: string; _left, _top, _right, _bottom: single; _alignHorizontal:  TTextAlignHorizontal; _alignVertical: TTextAlignVertical);
// where:
// TTextAlignHorizontal = (thLeft, thRight, thCenter);
// TTextAlignVertical = (tvTop, tvBottom, tvCenter);

// screen_width, screen_height, table_width, table_height: Integer;


  if(slideshow_mode = true) then
  begin
    //TableView.Canvas.PaintColor := colbrRed; // colbrDefault = transparent, colbrWhite
    TableView.Canvas.PaintColor := colbrBlue; // colbrDefault = transparent, colbrWhite
    TableView.Canvas.PaintStyle := psFill;
//  TableView.Canvas.PaintStrokeWidth := 20.0;
    TableView.Canvas.PaintTextSize := 20;

    draw_text_height := Round(TableView.Canvas.GetTextHeight('Cg'));


    TableView.Canvas.DrawTextAligned(OutputLabel.Text, 0, screen_height_half_size, screen_width, screen_height_half_size + draw_text_height, thCenter, tvCenter);
    TableView.Canvas.DrawTextAligned('(total 1641 variants of solution exists)', 0, screen_height_half_size + draw_text_height + 10, screen_width, screen_height_half_size + 2*draw_text_height + 10, thCenter, tvCenter);
    TableView.Canvas.DrawTextAligned(DateLabel.Text, 0, screen_height_half_size + 2*draw_text_height + 40, screen_width, screen_height_half_size + 3*draw_text_height + 40, thCenter, tvCenter);

    //TableView.Canvas.PaintTextSize := 12;
    //TableView.Canvas.PaintColor := colbrBlack; // colbrDefault = transparent, colbrWhite
    //TableView.Canvas.DrawTextAligned('Start new game by going to Settings tab', 0, screen_height_half_size + 4*draw_text_height + 10, screen_width, screen_height_half_size + 5*draw_text_height, thCenter, tvCenter);
    //TableView.Canvas.DrawTextAligned('and pressing “New game” button.', 0, screen_height_half_size + 5*draw_text_height + 10, screen_width, screen_height_half_size + 6*draw_text_height, thCenter, tvCenter);

  end // if(slideshow_mode = true) then
  else if((congratulations_visible = 1) or (redraw_pieces_after_simplify_solution = true)) then
  begin
    //TableView.Canvas.PaintColor := colbrRed; // colbrDefault = transparent, colbrWhite
    TableView.Canvas.PaintColor := colbrBlue; // colbrDefault = transparent, colbrWhite
    TableView.Canvas.PaintStyle := psFill;
//  TableView.Canvas.PaintStrokeWidth := 20.0;
    TableView.Canvas.PaintTextSize := 20;

    draw_text_height := Round(TableView.Canvas.GetTextHeight('Cg'));


    TableView.Canvas.DrawTextAligned('Congratulations!', 0, screen_height_half_size, screen_width, screen_height_half_size + draw_text_height, thCenter, tvCenter);
    TableView.Canvas.DrawTextAligned('You have solved the puzzle.', 0, screen_height_half_size + draw_text_height + 10, screen_width, screen_height_half_size + 2*draw_text_height, thCenter, tvCenter);

    if(solution_already_exists = 0) then
    begin
      TableView.Canvas.DrawTextAligned('Your solved puzzle was saved to file.', 0, screen_height_half_size + 2*draw_text_height + 10, screen_width, screen_height_half_size + 3*draw_text_height, thCenter, tvCenter);

      TableView.Canvas.PaintTextSize := 12;
      TableView.Canvas.PaintColor := colbrBlack; // colbrDefault = transparent, colbrWhite
      TableView.Canvas.DrawTextAligned('Start new game by going to Settings tab', 0, screen_height_half_size + 4*draw_text_height + 10, screen_width, screen_height_half_size + 5*draw_text_height, thCenter, tvCenter);
      TableView.Canvas.DrawTextAligned('and pressing “New game” button.', 0, screen_height_half_size + 5*draw_text_height + 10, screen_width, screen_height_half_size + 6*draw_text_height, thCenter, tvCenter);
    end
    else
    begin
      TableView.Canvas.DrawTextAligned(solution_already_exists_string_1, 0, screen_height_half_size + 2*draw_text_height + 10, screen_width, screen_height_half_size + 3*draw_text_height, thCenter, tvCenter);
      TableView.Canvas.DrawTextAligned(solution_already_exists_string_2, 0, screen_height_half_size + 3*draw_text_height + 10, screen_width, screen_height_half_size + 4*draw_text_height, thCenter, tvCenter);
      TableView.Canvas.DrawTextAligned(solution_already_exists_string_3, 0, screen_height_half_size + 4*draw_text_height + 10, screen_width, screen_height_half_size + 5*draw_text_height, thCenter, tvCenter);

      TableView.Canvas.PaintTextSize := 12;
      TableView.Canvas.PaintColor := colbrBlack; // colbrDefault = transparent, colbrWhite
      TableView.Canvas.DrawTextAligned('Start new game by going to Settings tab', 0, screen_height_half_size + 6*draw_text_height + 10, screen_width, screen_height_half_size + 7*draw_text_height, thCenter, tvCenter);
      TableView.Canvas.DrawTextAligned('and pressing “New game” button.', 0, screen_height_half_size + 7*draw_text_height + 10, screen_width, screen_height_half_size + 8*draw_text_height, thCenter, tvCenter);
    end;



  end; // else if((congratulations_visible = 1) or (redraw_pieces_after_simplify_solution = true)) then

  redraw_current_piece_finished := 1;


end;




procedure TPuzzleGameForm.RedrawCurrentPieceFromTBGRABitmap();
begin

// Function works, but it is not used by program. Program uses equivalent function RedrawCurrentPiece.
// Piece rotation and flipping does not work when this function is used, program code of this function needs to be updated


  if(redraw_current_piece_finished = 0) then
  Exit();

  redraw_current_piece_finished := 0;


  if (background_of_board_already_drawn = 0) then
  begin
    DrawBackgroundOfBoard();
    background_of_board_already_drawn := 1;
  end;


  if((current_piece > 0) and (previous_current_piece <> current_piece)) then
  //if(previous_current_piece <> current_piece) then
  begin
  DrawBackgroundOfBoard();
  DebugLabel.Text := 'piece = ' + IntToStr(current_piece);
//  ShowMessage('piece = ' + IntToStr(current_piece));
  end;



  TableView.Canvas.PaintColor := colbrWhite; // colbrDefault = transparent, colbrWhite
  TableView.Canvas.PaintStyle := psFill;
//  TableView.Canvas.PaintStrokeWidth := 20.0;
//  TableView.Canvas.DrawBitmap(0,0, BackgroundCanvas.GetBitmap());
//  TableCanvas.PaintColor := colbrWhite; // colbrDefault = transparent, colbrWhite
//  TableCanvas.PaintStyle := psFill;
  TableCanvas.DrawBitmap(0,0, BackgroundCanvas.GetBitmap());


  if(current_piece = 1) then
  begin
  //piece01_left := 0;
  //piece01_top := piece01_bottom + piece01_height;
  piece01_bottom := piece01_top - piece01_height;
  piece01_right := piece01_left + piece01_width;

  piece_image_01.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_01);
      jBitmap1.LoadFromStream(memory_stream);
      //ReceptiveFieldCanvas.SetBitmap(jBitmap1.GetImage());
      // TableView.SetImage(jBitmap1.GetImage());
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece01_left, piece01_bottom, piece01_right, piece01_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece01_left+piece_half_size, piece01_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 1) then

  if(current_piece = 2) then
  begin
  piece02_bottom := piece02_top - piece02_height;
  piece02_right := piece02_left + piece02_width;

  piece_image_02.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_02);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece02_left, piece02_bottom, piece02_right, piece02_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece02_left+piece_half_size, piece02_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 2) then


  if(current_piece = 3) then
  begin
  piece03_bottom := piece03_top - piece03_height;
  piece03_right := piece03_left + piece03_width;

  piece_image_03.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_03);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece03_left, piece03_bottom, piece03_right, piece03_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece03_left+piece_half_size, piece03_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 3) then

  if(current_piece = 4) then
  begin
  piece04_bottom := piece04_top - piece04_height;
  piece04_right := piece04_left + piece04_width;

  piece_image_04.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_04);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece04_left, piece04_bottom, piece04_right, piece04_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece04_left+piece_half_size, piece04_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 4) then

  if(current_piece = 5) then
  begin
  piece05_bottom := piece05_top - piece05_height;
  piece05_right := piece05_left + piece05_width;

  piece_image_05.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_05);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece05_left, piece05_bottom, piece05_right, piece05_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece05_left+piece_half_size, piece05_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 5) then


  if(current_piece = 6) then
  begin
  piece06_bottom := piece06_top - piece06_height;
  piece06_right := piece06_left + piece06_width;

  piece_image_06.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_06);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece06_left, piece06_bottom, piece06_right, piece06_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece06_left+piece_half_size, piece06_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 6) then


  if(current_piece = 7) then
  begin
  piece07_bottom := piece07_top - piece07_height;
  piece07_right := piece07_left + piece07_width;

  piece_image_07.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_07);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece07_left, piece07_bottom, piece07_right, piece07_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece07_left+piece_half_size, piece07_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 7) then


  if(current_piece = 8) then
  begin
  piece08_bottom := piece08_top - piece08_height;
  piece08_right := piece08_left + piece08_width;

  piece_image_08.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_08);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece08_left, piece08_bottom, piece08_right, piece08_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece08_left+piece_half_size, piece08_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 7) then


  if(current_piece = 9) then
  begin
  piece09_bottom := piece09_top - piece09_height;
  piece09_right := piece09_left + piece09_width;

  piece_image_09.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_09);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece09_left, piece09_bottom, piece09_right, piece09_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece09_left+piece_half_size, piece09_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 9) then


  if(current_piece = 10) then
  begin
  piece10_bottom := piece10_top - piece10_height;
  piece10_right := piece10_left + piece10_width;

  piece_image_10.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_10);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece10_left, piece10_bottom, piece10_right, piece10_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece10_left+piece_half_size, piece10_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 10) then


  if(current_piece = 11) then
  begin
  piece11_bottom := piece11_top - piece11_height;
  piece11_right := piece11_left + piece11_width;

  piece_image_11.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_11);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece11_left, piece11_bottom, piece11_right, piece11_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece11_left+piece_half_size, piece11_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 11) then


  if(current_piece = 12) then
  begin
  piece12_bottom := piece12_top - piece12_height;
  piece12_right := piece12_left + piece12_width;

  piece_image_12.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_12);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece12_left, piece12_bottom, piece12_right, piece12_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece12_left+piece_half_size, piece12_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 12) then


  if(current_piece = 13) then
  begin
  piece13_bottom := piece13_top - piece13_height;
  piece13_right := piece13_left + piece13_width;

  piece_image_13.InvalidateBitmap;
  png_writer := TFPWriterPNG.Create;
  try
    memory_stream := TMemoryStream.Create;
    try
      TFPWriterPNG(png_writer).UseAlpha := true;
      png_writer.ImageWrite(memory_stream, piece_image_13);
      jBitmap1.LoadFromStream(memory_stream);
      TableView.Canvas.drawBitmap(jBitmap1.GetImage(), piece13_left, piece13_bottom, piece13_right, piece13_top);  // b l r t  <-- incorrect names, must be l b r t
      TableView.Canvas.DrawCircle(piece13_left+piece_half_size, piece13_top-piece_half_size, current_piece_marking_ellipse_radius);
    finally
      memory_stream.Free;
    end;
  finally
    png_writer.Free;
  end;
  end; // if(current_piece = 13) then


  redraw_current_piece_finished := 1;


end;


procedure TPuzzleGameForm.TableViewDraw(Sender: TObject);
begin

    TableView.OnTouchMove := nil;

//  if(current_piece = 0)then
//  DrawBackgroundOfBoard();

  if((slideshow_mode = true) or (redraw_pieces_after_simplify_solution = true)) then
  begin
    current_piece := 1;
    RotatePiece();
    current_piece := 2;
    RotatePiece();
    current_piece := 3;
    RotatePiece();
    current_piece := 4;
    RotatePiece();
    current_piece := 5;
    RotatePiece();
    current_piece := 6;
    RotatePiece();
    current_piece := 7;
    RotatePiece();
    current_piece := 8;
    RotatePiece();
    current_piece := 9;
    RotatePiece();
    current_piece := 10;
    RotatePiece();
    current_piece := 11;
    RotatePiece();
    current_piece := 12;
    RotatePiece();
    current_piece := 13;
    RotatePiece();
//    current_piece := 0;
//    previous_current_piece := -1;
//    DrawBackgroundOfBoard(); // does not work, produces empty screen
    redraw_current_piece_finished := 1;
    background_of_board_already_drawn := 1;
    RedrawCurrentPiece(); // this function needed because we need writing on screen (date + total 1641 variants of solution exists), which is inside function RedrawCurrentPiece()
    current_piece := 0;
  end
  else
  begin
    RedrawCurrentPiece();
  end;


//  TableView.Canvas.PaintColor := colbrRed; // colbrDefault = transparent, colbrWhite
//  TableView.Canvas.PaintStyle := psFill;
////  TableView.Canvas.PaintStrokeWidth := 20.0;
//  TableView.Canvas.drawText('finger_coordinates(x,y)= (' + IntToStr(finger_coordinates.X) + ',' + IntToStr(finger_coordinates.Y)+')',60,60);


  TableView.OnTouchMove := @TableViewTouchMove;

end;


procedure TPuzzleGameForm.TableViewTouchDown(Sender: TObject; Touch: TMouch);
var
  temp_x_distance, temp_y_distance, min_distance: Integer;
begin

  error_circle_image_visible := 0;


  if(slideshow_mode = true) then
  Exit();

  if(MoveToNearestSlotAnimationTimer.Enabled = true) then // workaround solution for: while piece is moving, click outside board and piece disappears.
  Exit();

//  TableView.Enabled := false;
  FlipButton.Enabled := false;
  Rot60PlusButton.Enabled := false;
  Rot60MinusButton.Enabled := false;



  TableView.OnTouchMove := nil;

  finger_coordinates := Point( Round(Touch.Pt.X), Round(Touch.Pt.Y) );

  if(current_piece > 1) then
  saved_current_piece := current_piece;

  current_piece := 0;



  //min_x_distance := MaxInt;
  //min_y_distance := MaxInt;
  min_distance := MaxInt;

  temp_x_distance := abs(finger_coordinates.X - (piece01_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece01_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 1;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece02_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece02_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 2;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece03_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece03_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 3;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece04_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece04_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 4;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece05_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece05_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 5;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece06_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece06_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 6;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece07_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece07_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 7;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece08_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece08_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 8;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece09_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece09_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 9;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then


  temp_x_distance := abs(finger_coordinates.X - (piece10_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece10_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 10;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece11_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece11_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 11;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece12_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece12_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 12;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then

  temp_x_distance := abs(finger_coordinates.X - (piece13_left + piece_half_size));
  temp_y_distance := abs(finger_coordinates.Y - (piece13_top - piece_half_size));

  if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then
  begin
  if ((temp_x_distance + temp_y_distance) < min_distance) then
  begin
    min_distance := temp_x_distance + temp_y_distance;
    current_piece := 13;
  end;
  end; // if((temp_x_distance < piece_half_size) and (temp_y_distance < piece_half_size)) then



  if((current_piece > 0) and (previous_current_piece <> current_piece)) then
  //if(previous_current_piece <> current_piece) then
  TableView.Refresh();



  //TableView.OnTouchMove := @TableViewTouchMove;

end;

//----------------------------------------




//  ClearSlot(piece_slot_address[12]);
procedure TPuzzleGameForm.ClearSlot(slot_number: Integer);
var
   n: Integer;
begin

OutputLabel.Visible := false;
DateLabel.Visible := false;


if((slot_number < 1) or (slot_number > 12) or (current_piece < 1) or (current_piece > 12)) then
begin
Exit();
end;


piece_slot_address[current_piece-1] := 0;
slot_content[slot_number-1] := 0;
current_slot := 0;


for n := 0 to 5 do
begin
board_spike_table[(slot_number-1)*6 + n] := 0;
end;


//for n := 0 to 77 do // 6 *13 = 78
//board_colliding_spikes_table[n] := 0;


end;


function TPuzzleGameForm.FindCollidingSpikesCoordinates(slot_number_1: Integer; spike_position_1: Integer; slot_number_2: Integer; spike_position_2: Integer): Integer;
var i, i2: Integer;
begin

error_circle_image_visible := 0;


{$IFDEF ANDROID}
DebugLabel.Text := 'no collisions found';
{$ELSE}
DebugLabel.Caption := 'no collisions found';
{$ENDIF}


if ((slot_number_1 < 1) or (slot_number_2 < 1)) then
ShowMessage('Error: (slot_number_1 < 1) or (slot_number_2 < 1)');



i :=  (slot_number_1-1)*6 + spike_position_1-1;
i2 := (slot_number_2-1)*6 + spike_position_2-1;



board_colliding_spikes_table[i] := board_colliding_spikes_table[i] + board_colliding_spikes_table[i2];


if(board_colliding_spikes_table[i] > 1) then
begin
//SaveButton.Enabled := false;


error_spike_angle := DegToRad(((spike_position_1-1)*60)-90);

//ErrorCircleImage.Left := slot_left[slot_number_1-1];
//ErrorCircleImage.Top := slot_top[slot_number_1-1];


{$IFDEF ANDROID}
//xx error_circle_image_left := slot_left[slot_number_1-1] + piece_half_size + Round(80*cos(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;
//xx error_circle_image_top := slot_top[slot_number_1-1] + piece_half_size + Round(80*sin(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;

error_circle_image_left := slot_left[slot_number_1-1] + piece_half_size + Round(PIECE_SIZE*80/200*cos(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;
error_circle_image_top := slot_top[slot_number_1-1] - board_offset_y_for_table_draw + 30 + piece_half_size + Round(PIECE_SIZE*80/200*sin(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;



{$ELSE}
ErrorCircleImage.Left := slot_left[slot_number_1-1] + piece_half_size + Round(80*cos(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;
ErrorCircleImage.Top := slot_top[slot_number_1-1] + piece_half_size + Round(80*sin(error_spike_angle) - current_piece_marking_ellipse_radius) - error_circle_pen_width_div_2;
{$ENDIF}




{$IFDEF ANDROID}
error_circle_image_visible := 1;
TableView.Refresh();
{$ELSE}
ErrorCircleImage.BringToFront();
ErrorCircleImage.Visible := true;
{$ENDIF}


//DebugLabel.Visible := true;
//DebugLabel.Caption := 'error_spike_angle = ' + FloatToStr(error_spike_angle) + ', x = ' + FloatToStr(80*cos(error_spike_angle)) + ', y = ' + FloatToStr(80*sin(error_spike_angle));

//DebugLabel.Caption := 'collision at slot ' + IntToStr(slot_number_1) + ' spike = ' + IntToStr(spike_position_1) + '(' + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 0]) + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 1]) + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 2]) + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 3]) + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 4]) + IntToStr(board_colliding_spikes_table[(slot_number_1-1)*6 + 5]) + ')' +

{$IFDEF ANDROID}
DebugLabel.Text := 'collision at slot ' + IntToStr(slot_number_1) + ' spike ' + IntToStr(spike_position_1) + '(' + IntToStr(board_spike_table[(slot_number_1-1)*6 + 0]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 1]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 2]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 3]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 4]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 5]) + ')' +
 ' and slot ' + IntToStr(slot_number_2) + ' spike ' + IntToStr(spike_position_2) + '(' + IntToStr(board_spike_table[(slot_number_2-1)*6 + 0]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 1]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 2]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 3]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 4]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 5]) + ')';
{$ELSE}
DebugLabel.Caption := 'collision at slot ' + IntToStr(slot_number_1) + ' spike ' + IntToStr(spike_position_1) + '(' + IntToStr(board_spike_table[(slot_number_1-1)*6 + 0]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 1]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 2]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 3]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 4]) + IntToStr(board_spike_table[(slot_number_1-1)*6 + 5]) + ')' +
 ' and slot ' + IntToStr(slot_number_2) + ' spike ' + IntToStr(spike_position_2) + '(' + IntToStr(board_spike_table[(slot_number_2-1)*6 + 0]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 1]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 2]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 3]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 4]) + IntToStr(board_spike_table[(slot_number_2-1)*6 + 5]) + ')';
{$ENDIF}


end; //if(board_colliding_spikes_table[i] > 1)


result := board_colliding_spikes_table[i];

end;


// PlacePieceIntoBoardToFindCollisions(1, current_slot);
procedure TPuzzleGameForm.PlacePieceIntoBoardToFindCollisions(piece_number: Integer; slot_number: Integer);
var
   n, n1, n2, slot_number_2, number_of_filled_slots: Integer;
   piece_spikes_rotated_and_flipped: array [0 .. 5] of Integer;
   temp_spike, rotation_steps: Integer;
begin

if (slot_number = 0) then
Exit();

if(redraw_pieces_after_simplify_solution = true) then  // DEBUG DELETE
Exit(); // DEBUG DELETE



{$IFNDEF ANDROID}
 ErrorCircleImage.Visible := false;
{$ENDIF} // IFNDEF ANDROID

 DebugLabel.Visible := false;
 OutputLabel.Visible := false;
 DateLabel.Visible := false;



//check for duplicate error
 for n := 0 to 12 do
 begin
   for n2 := 0 to 12 do
   begin
     if (n <> n2) then
     begin

       if ((slot_content[n] = slot_content[n2]) and (slot_content[n] <> 0)) then
       begin
       {$IFDEF ANDROID}
       //xx DebugLabel.Visible := true;
       DebugLabel.Text := 'Error: slot_content duplicates for slots: ' + IntToStr(n+1) + ', ' + IntToStr(n2+1)+  ', slot_content = ' + IntToStr(slot_content[n]);
       {$ELSE}
       DebugLabel.Visible := true;
       DebugLabel.Caption := 'Error: slot_content duplicates for slots: ' + IntToStr(n+1) + ', ' + IntToStr(n2+1)+  ', slot_content = ' + IntToStr(slot_content[n]);
       {$ENDIF}
        Exit();
       end;

       if ((piece_slot_address[n] = piece_slot_address[n2]) and (piece_slot_address[n] <> 0)) then
       begin
        {$IFDEF ANDROID}
        //xx DebugLabel.Visible := true;
        DebugLabel.Text := 'Error: piece_slot_address duplicates for pieces: ' + IntToStr(n+1) + ', ' + IntToStr(n2+1) +  ', piece_slot_address = ' + IntToStr(piece_slot_address[n]);
        {$ELSE}
        DebugLabel.Visible := true;
        DebugLabel.Caption := 'Error: piece_slot_address duplicates for pieces: ' + IntToStr(n+1) + ', ' + IntToStr(n2+1) +  ', piece_slot_address = ' + IntToStr(piece_slot_address[n]);
        {$ENDIF}
        Exit();
       end;

     end; //  if (n <> n2)
   end; //  for n2 := 0 to 12 do
 end; // for n := 0 to 12 do



 for n := 0 to 5 do
 piece_spikes_rotated_and_flipped[n] := piece_spike_table[(piece_number-1)*6 + n];



 if( piece_rotation_angle[piece_number-1] <> 0) then
 begin
   rotation_steps := piece_rotation_angle[piece_number-1] div 60;

//   DebugLabel.Visible := true;
//   DebugLabel.Caption := 'rotation_steps = ' + IntToStr(rotation_steps);

  if(rotation_steps < 0) then
  begin
  for n := 0 to (-1*rotation_steps)-1 do
  begin  //DebugLabel.Caption := '-1';
    temp_spike := piece_spikes_rotated_and_flipped[0];
    piece_spikes_rotated_and_flipped[0] := piece_spikes_rotated_and_flipped[1];
    piece_spikes_rotated_and_flipped[1] := piece_spikes_rotated_and_flipped[2];
    piece_spikes_rotated_and_flipped[2] := piece_spikes_rotated_and_flipped[3];
    piece_spikes_rotated_and_flipped[3] := piece_spikes_rotated_and_flipped[4];
    piece_spikes_rotated_and_flipped[4] := piece_spikes_rotated_and_flipped[5];
    piece_spikes_rotated_and_flipped[5] := temp_spike;
   end; //for n := 0 to rotation_steps do
  end //    if(rotation_steps < 0) do
  else
  begin   //DebugLabel.Caption := '+1';
  for n := 0 to rotation_steps-1 do
  begin
   temp_spike := piece_spikes_rotated_and_flipped[5];
   piece_spikes_rotated_and_flipped[5] := piece_spikes_rotated_and_flipped[4];
   piece_spikes_rotated_and_flipped[4] := piece_spikes_rotated_and_flipped[3];
   piece_spikes_rotated_and_flipped[3] := piece_spikes_rotated_and_flipped[2];
   piece_spikes_rotated_and_flipped[2] := piece_spikes_rotated_and_flipped[1];
   piece_spikes_rotated_and_flipped[1] := piece_spikes_rotated_and_flipped[0];
   piece_spikes_rotated_and_flipped[0] := temp_spike;
  end; //for n := 0 to rotation_steps do

  end; // else -->  if(rotation_steps < 0) do
 end; // if( piece_rotation_angle[piece_number-1] <> 0) then


 // 2 <-> 6  horizontal flip
 // 3 <-> 5 horizontal flip
  if (piece_is_flipped[piece_number-1] = true) then
  begin
 // ShowMessage('flipped');
    temp_spike := piece_spikes_rotated_and_flipped[1];
    piece_spikes_rotated_and_flipped[1] := piece_spikes_rotated_and_flipped[5];
    piece_spikes_rotated_and_flipped[5] := temp_spike;

    temp_spike := piece_spikes_rotated_and_flipped[2];
    piece_spikes_rotated_and_flipped[2] := piece_spikes_rotated_and_flipped[4];
    piece_spikes_rotated_and_flipped[4] := temp_spike;
  end;


 for n := 0 to 5 do
 board_spike_table[(slot_number-1)*6 + n] := piece_spikes_rotated_and_flipped[n];







 for n := 0 to 77 do // 6 *13 = 78
 board_colliding_spikes_table[n] := board_spike_table[n];


 //FindCollidingSpikesCoordinates(slot_number_1, spike_position1, slot_number_2, spike_position_2);

if (FindCollidingSpikesCoordinates(1, 2, 2, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(2, 2, 3, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(3, 2, 4, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(1, 5, 5, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(1, 4, 5, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(1, 4, 6, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(5, 2, 6, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(1, 3, 2, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(1, 3, 6, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(2, 5, 6, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(2, 4, 7, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(2, 4, 6, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(6, 2, 7, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(2, 3, 3, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(2, 3, 7, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(3, 5, 7, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(4, 3, 9, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(3, 4, 8, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(3, 4, 7, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(7, 2, 8, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(3, 3, 4, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(3, 3, 8, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(4, 5, 8, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(4, 4, 8, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(4, 4, 9, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(8, 2, 9, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(5, 4, 10, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(5, 3, 6, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(5, 3, 10, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(6, 5, 10, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(6, 4, 10, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(6, 4, 11, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(10, 2, 11, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(10, 3, 11, 5) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(11, 3, 12, 5) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(12, 3, 13, 5) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(13, 2, 9, 4) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(6, 3, 7, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(6, 3, 11, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(7, 5, 11, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(7, 4, 11, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(7, 4, 12, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(11, 2, 12, 6) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(7, 3, 8, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(7, 3, 12, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(8, 5, 12, 1) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(8, 4, 12, 2) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(8, 4, 13, 6) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(13, 6, 12, 2) > 1) then
Exit();
//===========
if (FindCollidingSpikesCoordinates(8, 3, 9, 5) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(8, 3, 13, 1) > 1) then
Exit();
if (FindCollidingSpikesCoordinates(9, 5, 13, 1) > 1) then
Exit();
//===========



number_of_filled_slots := 0;

for n := 0 to 12 do
if(slot_content[n] <> 0) then
Inc(number_of_filled_slots);



if(number_of_filled_slots = 13) then
begin

TableView.OnTouchUp := nil;
TableView.OnTouchMove := nil;
TableView.OnTouchDown := nil;

TableView.Enabled := false;
//FlipButton.Enabled := false; // do not do that -- buttons become invisible during slideshow
//Rot60PlusButton.Enabled := false; // do not do that -- buttons become invisible during slideshow
//Rot60MinusButton.Enabled := false; // do not do that -- buttons become invisible during slideshow


RotateToNearest60angleAnimationTimer.Enabled := false;
MoveToNearestSlotAnimationTimer.Enabled := false;

//previous_current_piece := -1; // ?? maybe not needed for Android
//current_piece := 0; // not needed for Android
current_slot := 0;



// https://wiki.freepascal.org/Format_function
// https://www.thoughtco.com/add-leading-zeroes-number-delphi-format-1057555
// Use a straightforward function to change how your number displays. Use format to make the conversion by supplying a value for length (the total length of the final output) and the number you want to pad:
// str := Format('%.*d',[length, number])
// To pad the number 7 with two leading zeroes, plug those values into the code:
// str := Format('%.*d',[3, 7]);
// The result is 007 with the value returned as a string.

if (CompareStr(date_and_time_string, '') = 0) then
begin
current_date := Now();
date_and_time_string := Format('%.*d',[4, YearOf(current_date)]) + '-' + Format('%.*d',[2, MonthOf(current_date)])  + '-' + Format('%.*d',[2, DayOf(current_date)])  + '   ' + Format('%.*d',[2, HourOf(current_date)]) + ':' + Format('%.*d',[2, MinuteOf(current_date)]) ;
{$IFDEF ANDROID}
DateLabel.Text := date_and_time_string;
{$ELSE}
DateLabel.Caption := date_and_time_string;
{$ENDIF}
end;

{$IFDEF ANDROID}



congratulations_visible := 1;
TableView.Refresh();

//OutputLabel.FontColor := colbrRed;
//OutputLabel.FontSize := 100;

//OutputLabel.Text := 'Congratulations!' + LineEnding + 'You have solved the puzzle.' + LineEnding + 'Your solved puzzle was saved to file.'; //'Now you can save your solved puzzle.';
//OutputLabel.Visible := true;
//DateLabel.Visible := true;
{$ELSE}
OutputImage.BringToFront();
OutputLabel.BringToFront();
OutputLabel.Caption := 'Congratulations. You have solved the puzzle.'; //'Now you can save your solved puzzle.';
OutputLabel.Visible := true;
DateLabel.Visible := true;
{$ENDIF}

SaveSolution();

end; // if(number_of_filled_slots = 13)



end;



procedure TPuzzleGameForm.UpdateSavedPuzzleFile(new_filename: TFileName; old_filename: TFileName);
begin

// https://www.freepascal.org/docs-html/rtl/dateutils/comparedatetime.html
// function CompareDateTime(const A: TDateTime; const B: TDateTime):TValueRelationship;
// CompareDateTime compares two timestamps A and B and returns the following results:
// < 0 if A is earlier in date/time than B.
// = 0 if A and B are the same date/time.
// > 0 if A is later in date/time than B.

puzzle_solutions_saved_file_age := 0;

// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
// if(Length(player_names_stringlist.Text) > 0) then
if((FileExists(new_filename)) and (FileExists(old_filename))) then
begin
puzzle_solutions_saved_file_age :=  CompareDateTime( DateOf(FileDateToDateTime(FileAge(new_filename))), DateOf(FileDateToDateTime(FileAge(old_filename))) );
if(  puzzle_solutions_saved_file_age = 0) then
puzzle_solutions_saved_file_age := CompareTime( FileDateToDateTime(FileAge(new_filename)), FileDateToDateTime(FileAge(old_filename)) );
end;

  // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
  // if(Length(player_names_stringlist.Text) = 0) then
  if((not FileExists(old_filename)) or ( puzzle_solutions_saved_file_age > 0))then
  begin
  DeleteFile(old_filename);
  CopyFile(new_filename, old_filename);
//  MessageDlgEx(PCHAR(new_filename + LineEnding + 'file updated to newer version.'), mtInformation, [mbOk], PuzzleGameForm)
//  MessageDlgEx(PCHAR('Saved puzzles file location:' + LineEnding + old_filename), mtInformation, [mbOk], PuzzleGameForm)
  end;


end;



procedure TPuzzleGameForm.CopyFilesFromAssetsToInternalDirectory();
var
  n: Integer;
  copied_file_name_string: String;
begin


  jFileProviderInternal.FileSource:= srcInternal;
  copied_file_name_string := '';

  try
  player_names_stringlist.Text := jFileProviderInternal.GetTextContent(player_names_filename);

  //if(Length(player_names_stringlist.Text) > 0) then
  //ShowMessage('Player selected: ' + player_names_stringlist.Strings[0])
  //else
  //ShowMessage('Empty file');

  // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
  if(Length(player_names_stringlist.Text) = 0) then
  begin

    copied_file_name_string := CopyFromAssetsToInternalAppStorage(player_names_filename);

    copied_file_name_string := CopyFromAssetsToInternalAppStorage('Player.txt');  // Crashed when file size was zero(0), this bug was fixed in file "jForm.java"

    player_names_stringlist.Text := jFileProviderInternal.GetTextContent(player_names_filename);

    for n := 1 to player_names_stringlist.Count - 1 do
    begin
      puzzle_solutions_filename := player_names_stringlist.Strings[n] + '.txt';
      puzzle_solutions_full_filename := puzzle_solutions_filename; // Android Fix
      copied_file_name_string := CopyFromAssetsToInternalAppStorage(puzzle_solutions_filename);
    end; // for n:= 0 to player_names_stringlist.Lines.Count-1 do


   // ShowMessage('Installation succeeded.');

  end // if(Length(player_names_stringlist.Text) = 0) then
  else
  begin
   // ShowMessage('Saved solutions loaded.');
  end;


  except
  //  ShowMessage('Error: failed to copy file.');
  end;





end;




procedure TPuzzleGameForm.LoadPlayerNames();
var
  n: Integer;
begin



//When app is already running, the needed version of program code is:
PlayerSelectComboBox.Clear();               // In event OnCreate() the needed version is: --> PlayerSelectComboBox.Items.Clear();
PlayerSelectComboBox.Add('Add new player'); // In event OnCreate() the needed version is: --> PlayerSelectComboBox.Items.Add('Add new player');
PlayerSelectComboBox.Add('Delete player');
PlayerSelectComboBox.Add('Player');



try
//player_names_stringlist.Text := jFileProviderInternal.GetTextContent(player_names_full_filename);
player_names_stringlist.Text := jFileProviderInternal.GetTextContent(player_names_filename);


for n := 1 to player_names_stringlist.Count - 1 do
begin
  PlayerSelectComboBox.Add(player_names_stringlist.Strings[n]);
  puzzle_solutions_filename := player_names_stringlist.Strings[n] + '.txt';
//xx  puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename;
  puzzle_solutions_full_filename := puzzle_solutions_filename; // Android Fix
//xx  UpdateSavedPuzzleFile(resources_filepath + puzzle_solutions_filename, puzzle_solutions_full_filename);  // Android Fix
end; // for n:= 0 to player_names_stringlist.Lines.Count-1 do


combobox_item_selected := StrToIntDef(player_names_stringlist.Strings[0], 0) + 2;

if(combobox_item_selected < 3) then
begin
  PlayerSelectComboBox.SetSelectedIndex(2); // Player
end
else
begin
  PlayerSelectComboBox.SetSelectedIndex(combobox_item_selected); // Player
end;



//-------------------------------
if((PlayerSelectComboBox.GetSelectedIndex() - 2) > 0) then
begin
puzzle_solutions_filename := player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2] + '.txt';
//xx puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename;
puzzle_solutions_full_filename := puzzle_solutions_filename; // Android Fix
end
else
begin
puzzle_solutions_filename := 'Player.txt';
//xx puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename;
puzzle_solutions_full_filename := puzzle_solutions_filename; // Android Fix
end;

//ShowMessage(puzzle_solutions_filename);



except
//
end;


if(player_names_loaded = 0) then
begin
  on_app_start_combobox_item_selected := PlayerSelectComboBox.GetSelectedIndex() - 2;
  player_names_loaded := 1;
end;


end;




procedure TPuzzleGameForm.ClearBoard();
var
 n: Integer;
begin




for n := 0 to 12 do
slot_content[n] := 0;

for n := 0 to 77 do // 6 *13 = 78
board_spike_table[n] := 0;


for n := 0 to 77 do // 6 *13 = 78
board_colliding_spikes_table[n] := 0;



piece_rotation_angle[0] := 0;
piece_rotation_angle[1] := 0;
piece_rotation_angle[2] := 0;
piece_rotation_angle[3] := 0;
piece_rotation_angle[4] := 0;
piece_rotation_angle[5] := 0;
piece_rotation_angle[6] := 0;
piece_rotation_angle[7] := 0;
piece_rotation_angle[8] := 0;
piece_rotation_angle[9] := 0;
piece_rotation_angle[10] := 0;
piece_rotation_angle[11] := 0;
piece_rotation_angle[12] := 0;


slot_content[0] := 0;
slot_content[1] := 0;
slot_content[2] := 0;
slot_content[3] := 0;
slot_content[4] := 0;
slot_content[5] := 0;
slot_content[6] := 0;
slot_content[7] := 0;
slot_content[8] := 0;
slot_content[9] := 0;
slot_content[10] := 0;
slot_content[11] := 0;
slot_content[12] := 0;


// Android Fix begin
piece_is_flipped[0] := false;
piece_is_flipped[1] := false;
piece_is_flipped[2] := false;
piece_is_flipped[3] := false;
piece_is_flipped[4] := false;
piece_is_flipped[5] := false;
piece_is_flipped[6] := false;
piece_is_flipped[7] := false;
piece_is_flipped[8] := false;
piece_is_flipped[9] := false;
piece_is_flipped[10] := false;
piece_is_flipped[11] := false;
piece_is_flipped[12] := false;
// Android Fix end


end;

procedure TPuzzleGameForm.StartNewGame();
var
 n: Integer;
begin

ClearBoard();

for n := 1 to 13 do
PlacePieceToStartPosition(n);




end;

procedure TPuzzleGameForm.PlacePieceToStartPosition(piece_number: Integer);
begin

    if (piece_number = 1) then
    begin
    piece01_left := 0;
    piece01_top := pieces_top;
    piece_is_flipped[0] := false;
    piece_slot_address[0] := 0;
//    piece_rotation_angle[0] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[0], 1)
    end
    else if (piece_number = 2) then
    begin
    piece02_left := distance_between_pieces;
    piece02_top := pieces_top;
    piece_is_flipped[1] := false;
    piece_slot_address[1] := 0;
//    piece_rotation_angle[1] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[1], 2)
    end
    else if (piece_number = 3) then
    begin
    piece03_left := distance_between_pieces*2;
    piece03_top := pieces_top;
    piece_is_flipped[2] := false;
    piece_slot_address[2] := 0;
//    piece_rotation_angle[2] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[2], 3)
    end
    else if (piece_number = 4) then
    begin
    piece04_left := distance_between_pieces*3;
    piece04_top := pieces_top;
    piece_is_flipped[3] := false;
    piece_slot_address[3] := 0;
//    piece_rotation_angle[3] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[3], 4)
    end
    else if (piece_number = 5) then
    begin
    piece05_left := 0; // distance_between_pieces*4;
    piece05_top := pieces_top+distance_between_pieces; // pieces_top;
    piece_is_flipped[4] := false;
    piece_slot_address[4] := 0;
//    piece_rotation_angle[4] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[4], 5)
    end
    else if (piece_number = 6) then
    begin
    piece06_left := distance_between_pieces; // distance_between_pieces*5;
    piece06_top := pieces_top+distance_between_pieces; // pieces_top;
    piece_is_flipped[5] := false;
    piece_slot_address[5] := 0;
//    piece_rotation_angle[5] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[5], 6)
    end
    else if (piece_number = 7) then
    begin
    piece07_left := distance_between_pieces*2; //distance_between_pieces*6;
    piece07_top := pieces_top+distance_between_pieces; // pieces_top;
    piece_is_flipped[6] := false;
    piece_slot_address[6] := 0;
//    piece_rotation_angle[6] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[6], 7)
    end
    else if (piece_number = 8) then
    begin
    piece08_left := distance_between_pieces*3; //0;
    piece08_top := pieces_top+distance_between_pieces; // pieces_top+distance_between_pieces;
    piece_is_flipped[7] := false;
    piece_slot_address[7] := 0;
//    piece_rotation_angle[7] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[7], 8)
    end
    else if (piece_number = 9) then
    begin
    piece09_left := 0; //distance_between_pieces;
    piece09_top := pieces_top+distance_between_pieces*2; // pieces_top+distance_between_pieces;
    piece_is_flipped[8] := false;
    piece_slot_address[8] := 0;
//    piece_rotation_angle[8] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[8], 9)
    end
    else if (piece_number = 10) then
    begin
    piece10_left := distance_between_pieces; //distance_between_pieces*2;
    piece10_top := pieces_top+distance_between_pieces*2; // pieces_top+distance_between_pieces;
    piece_is_flipped[9] := false;
    piece_slot_address[9] := 0;
//    piece_rotation_angle[9] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[9], 10)
    end
    else if (piece_number = 11) then
    begin
    piece11_left := distance_between_pieces*2; // distance_between_pieces*3;
    piece11_top := pieces_top+distance_between_pieces*2; // pieces_top+distance_between_pieces;
    piece_is_flipped[10] := false;
    piece_slot_address[10] := 0;
//    piece_rotation_angle[10] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[10], 11)
    end
    else if (piece_number = 12) then
    begin
    piece12_left := distance_between_pieces*3; // distance_between_pieces*4;
    piece12_top := pieces_top+distance_between_pieces*2; // pieces_top+distance_between_pieces;
    piece_is_flipped[11] := false;
    piece_slot_address[11] := 0;
//    piece_rotation_angle[11] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[11], 12)
    end
    else if (piece_number = 13) then
    begin
    piece13_left := distance_between_pieces*3; // 0; // distance_between_pieces*5;
    piece13_top := pieces_top+distance_between_pieces*3; //pieces_top+distance_between_pieces;
    piece_is_flipped[12] := false;
    piece_slot_address[12] := 0;
//    piece_rotation_angle[12] := 0;
//    ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[12], 13)
    end;


end;

(*
procedure TPuzzleGameForm.RotateToNearest60angleAnimationTimerStartTimer(Sender: TObject);
begin

//    rotation_increment_default := 5;
rotation_increment_default := 1;
date_and_time_string := '';


    rotation_increment := final_rotation_angle - current_rotation_angle;


    if((final_rotation_angle = 0) and (rotation_increment < 30)) then
    rotation_increment := -rotation_increment_default
    else if((final_rotation_angle = 0) and (rotation_increment > -30)) then
    rotation_increment := rotation_increment_default

    else if((final_rotation_angle = 360) and (rotation_increment < 30)) then
    rotation_increment := rotation_increment_default
    else if((final_rotation_angle = 360) and (rotation_increment > -30)) then
    rotation_increment := -rotation_increment_default

    else if(rotation_increment > 0) then
    rotation_increment := rotation_increment_default
    else
    rotation_increment := -rotation_increment_default;





end;
*)

procedure TPuzzleGameForm.RotateToNearest60angleAnimationTimerTimer(Sender: TObject);
var
   finish_rotation: Boolean;
begin

Exit(); // DEBUG DELETE

    finish_rotation := false;
    current_rotation_angle := current_rotation_angle + rotation_increment;

    if(current_rotation_angle >= 360) then
    begin
    current_rotation_angle := current_rotation_angle - 360;
    finish_rotation := true;
    end
    else if(current_rotation_angle < 0) then
    begin
    current_rotation_angle := current_rotation_angle + 360;
    finish_rotation := true;
    end;


    angle_difference := current_rotation_angle - final_rotation_angle;

    if ((finish_rotation = true) or (abs(angle_difference) < (rotation_increment_default+2))) then
    begin

    RotateToNearest60angleAnimationTimer.Enabled := false;
    piece_rotation_angle[current_piece-1] := final_rotation_angle;
    PlacePieceIntoBoardToFindCollisions(current_piece, current_slot);
    date_and_time_string := '';

    end; //if (current_rotation_angle = final_rotation_angle) then



    current_rotation_angle := final_rotation_angle;


    TableView.Refresh();


//DebugLabel.Caption := 'rotation_increment = ' + IntToStr(rotation_increment) + ', current_rotation_angle = ' + IntToStr(current_rotation_angle) + ', final_rotation_angle = ' + IntToStr(final_rotation_angle);


end;




procedure TPuzzleGameForm.ShowSolutionsTimerTimer(Sender: TObject);
begin

LoadNextSolution(1);

end;

procedure TPuzzleGameForm.TableViewTouchUp(Sender: TObject; Touch: TMouch);
begin

   if(slideshow_mode = true) then
   Exit();

   if(MoveToNearestSlotAnimationTimer.Enabled = true) then
   Exit();



  //finger_coordinates := Point( Round(Touch.Pt.X), Round(Touch.Pt.Y) );

  if(current_piece = 1) then
  Piece01MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 2) then
  Piece02MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 3) then
  Piece03MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 4) then
  Piece04MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 5) then
  Piece05MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 6) then
  Piece06MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 7) then
  Piece07MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 8) then
  Piece08MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 9) then
  Piece09MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 10) then
  Piece10MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 11) then
  Piece11MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 12) then
  Piece12MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y))
  else if(current_piece = 13) then
  Piece13MouseUp(Round(Touch.Pt.X), Round(Touch.Pt.Y));



// current_piece := 0;

 //if(current_piece < 1) then
 //current_piece := saved_current_piece;

 previous_current_piece := 0;

 TableView.OnTouchMove := @TableViewTouchMove;



  //previous_current_piece := current_piece;

  if (MoveToNearestSlotAnimationTimer.Enabled = false) then
  begin
    TableView.Enabled := true;
    FlipButton.Enabled := true;
    Rot60PlusButton.Enabled := true;
    Rot60MinusButton.Enabled := true;
  end;


end;


procedure TPuzzleGameForm.MoveToNearestSlotAnimationTimerStartTimer();
begin


TableView.Enabled := false;
FlipButton.Enabled := false;
Rot60PlusButton.Enabled := false;
Rot60MinusButton.Enabled := false;


date_and_time_string := '';


  if(current_piece = 1) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece01_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece01_top) / number_of_animation_steps;
   current_x_position := piece01_left;
   current_y_position := piece01_top;
  end
  else if(current_piece = 2) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece02_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece02_top) / number_of_animation_steps;
   current_x_position := piece02_left;
   current_y_position := piece02_top;
  end
  else if(current_piece = 3) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece03_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece03_top) / number_of_animation_steps;
   current_x_position := piece03_left;
   current_y_position := piece03_top;
  end
  else if(current_piece = 4) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece04_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece04_top) / number_of_animation_steps;
   current_x_position := piece04_left;
   current_y_position := piece04_top;
  end
  else if(current_piece = 5) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece05_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece05_top) / number_of_animation_steps;
   current_x_position := piece05_left;
   current_y_position := piece05_top;
  end
  else if(current_piece = 6) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece06_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece06_top) / number_of_animation_steps;
   current_x_position := piece06_left;
   current_y_position := piece06_top;
  end
  else if(current_piece = 7) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece07_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece07_top) / number_of_animation_steps;
   current_x_position := piece07_left;
   current_y_position := piece07_top;
  end
  else if(current_piece = 8) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece08_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece08_top) / number_of_animation_steps;
   current_x_position := piece08_left;
   current_y_position := piece08_top;
  end
  else if(current_piece = 9) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece09_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece09_top) / number_of_animation_steps;
   current_x_position := piece09_left;
   current_y_position := piece09_top;
  end
  else if(current_piece = 10) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece10_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece10_top) / number_of_animation_steps;
   current_x_position := piece10_left;
   current_y_position := piece10_top;
  end
  else if(current_piece = 11) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece11_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece11_top) / number_of_animation_steps;
   current_x_position := piece11_left;
   current_y_position := piece11_top;
  end
  else if(current_piece = 12) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece12_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece12_top) / number_of_animation_steps;
   current_x_position := piece12_left;
   current_y_position := piece12_top;
  end
  else if(current_piece = 13) then
  begin
   x_animation_increment := (slot_left[current_slot-1] - piece13_left) / number_of_animation_steps;
   y_animation_increment := (slot_top[current_slot-1] - piece13_top) / number_of_animation_steps;
   current_x_position := piece13_left;
   current_y_position := piece13_top;
  end;




end;


procedure TPuzzleGameForm.MoveToNearestSlotAnimationTimerTimer(Sender: TObject);
begin

//TableView.Canvas.PaintColor := colbrRed; // colbrDefault = transparent, colbrWhite
//TableView.Canvas.PaintStyle := psFill;
//TableView.Canvas.drawText('Timer x = ' + FloatToStr(current_x_position) + ', y=' + FloatToStr(current_y_position),60,60);



  if(current_piece = 1) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece01_left := Round(current_x_position);
   piece01_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece01_left := slot_left[current_slot-1];
      piece01_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(1, current_slot);
   end;

  end // if(current_piece = 1)
  else if(current_piece = 2) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece02_left := Round(current_x_position);
   piece02_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece02_left := slot_left[current_slot-1];
      piece02_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(2, current_slot);
   end;

  end // if(current_piece = 2)
  else if(current_piece = 3) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece03_left := Round(current_x_position);
   piece03_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece03_left := slot_left[current_slot-1];
      piece03_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(3, current_slot);
   end;

  end // if(current_piece = 3)
  else if(current_piece = 4) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece04_left := Round(current_x_position);
   piece04_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece04_left := slot_left[current_slot-1];
      piece04_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(4, current_slot);
   end;

  end // if(current_piece = 4)
  else if(current_piece = 5) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece05_left := Round(current_x_position);
   piece05_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece05_left := slot_left[current_slot-1];
      piece05_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(5, current_slot);
   end;

  end // if(current_piece = 5)
  else if(current_piece = 6) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece06_left := Round(current_x_position);
   piece06_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece06_left := slot_left[current_slot-1];
      piece06_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(6, current_slot);
   end;

  end // if(current_piece = 6)
  else if(current_piece = 7) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece07_left := Round(current_x_position);
   piece07_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece07_left := slot_left[current_slot-1];
      piece07_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(7, current_slot);
   end;

  end // if(current_piece = 7)
  else if(current_piece = 8) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece08_left := Round(current_x_position);
   piece08_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece08_left := slot_left[current_slot-1];
      piece08_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(8, current_slot);
   end;

  end // if(current_piece = 8)
  else if(current_piece = 9) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece09_left := Round(current_x_position);
   piece09_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece09_left := slot_left[current_slot-1];
      piece09_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(9, current_slot);
   end;

  end // if(current_piece = 9)
  else if(current_piece = 10) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece10_left := Round(current_x_position);
   piece10_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece10_left := slot_left[current_slot-1];
      piece10_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(10, current_slot);
   end;

  end // if(current_piece = 10)
  else if(current_piece = 11) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece11_left := Round(current_x_position);
   piece11_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece11_left := slot_left[current_slot-1];
      piece11_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(11, current_slot);
   end;

  end // if(current_piece = 11)
  else if(current_piece = 12) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece12_left := Round(current_x_position);
   piece12_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece12_left := slot_left[current_slot-1];
      piece12_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(12, current_slot);
   end;

  end // if(current_piece = 12)
  else if(current_piece = 13) then
  begin
   current_x_position := current_x_position + x_animation_increment;
   current_y_position := current_y_position + y_animation_increment;
   piece13_left := Round(current_x_position);
   piece13_top := Round(current_y_position);

   if (abs(current_x_position - slot_left[current_slot-1]) < 3) and (abs(current_y_position - slot_top[current_slot-1]) < 3) then
   begin
      MoveToNearestSlotAnimationTimer.Enabled := false;
      date_and_time_string := '';
      piece13_left := slot_left[current_slot-1];
      piece13_top := slot_top[current_slot-1];
      PlacePieceIntoBoardToFindCollisions(13, current_slot);
   end;

  end; // if(current_piece = 13)




TableView.Refresh();


if (MoveToNearestSlotAnimationTimer.Enabled = false) then
begin
  TableView.Enabled := true;
  FlipButton.Enabled := true;
  Rot60PlusButton.Enabled := true;
  Rot60MinusButton.Enabled := true;
end;


end;

procedure TPuzzleGameForm.PlayerSelectComboBoxItemSelected(Sender: TObject;
  itemCaption: string; itemIndex: integer);
begin

//  if((player_names_loaded = 0) and (copy_of_files_from_assets_completed = 1)) then
  if(player_names_loaded = 0) then
  Exit();


  if(redraw_pieces_after_simplify_solution = true) then
  Exit();



if(PlayerSelectComboBox.GetSelectedIndex() = 0) then
begin
  FlipButton.Visible := false;
  NewGameButton.Visible := false;
  ShowSavedSolutionsButton.Visible := false;
  PlayerNameEdit.Text := '';
  PlayerNameLabel.Text := 'Enter here name which you want to add';
  PlayerNameEdit.Visible := true;
  PlayerNameLabel.Visible := true;
  //HideSoftInput(); //  hide virtual keyboard
  //ShowSoftInput(); //  show virtual keyboard
  PlayerNameEdit.SetFocus;
  //PlayerNameEdit.SelectAll();
  AddDeletePlayerButton.Text := 'Add player';
  AddDeletePlayerButton.Visible := true;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;
end
else if(PlayerSelectComboBox.GetSelectedIndex() = 1) then
begin
  FlipButton.Visible := false;
  NewGameButton.Visible := false;
  ShowSavedSolutionsButton.Visible := false;
  PlayerNameEdit.Text := '';
  PlayerNameLabel.Text := 'Enter here name which you want to delete';
  PlayerNameEdit.Visible := true;
  PlayerNameLabel.Visible := true;
  //HideSoftInput(); //  hide virtual keyboard
  //ShowSoftInput(); //  show virtual keyboard
  PlayerNameEdit.SetFocus;
  //PlayerNameEdit.SelectAll();
  AddDeletePlayerButton.Text := 'Delete player';
  AddDeletePlayerButton.Visible := true;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;
end
else
begin
  FlipButton.Visible := false;
  NewGameButton.Visible := true;
  ShowSavedSolutionsButton.Visible := true;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;
  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := true;
  ImportSavedSolutionsButton.Visible := true;
  //xx player_names_stringlist.Lines[0] := IntToStr(PlayerSelectComboBox.GetSelectedIndex() - 2);
  //xx player_names_stringlist.Lines.SaveToFile(player_names_full_filename);
  //-------------------------------
  if ((PlayerSelectComboBox.GetSelectedIndex() - 2) > 0) then
  begin
  //xx puzzle_solutions_filename := player_names_stringlist.Lines[PlayerSelectComboBox.GetSelectedIndex() - 2] + '.txt';
  puzzle_solutions_filename := player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2] + '.txt';
  //puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename; // Android fix
  puzzle_solutions_full_filename := puzzle_solutions_filename; // Android fix
  end
  else
  begin
  puzzle_solutions_filename := 'Player.txt';
  //xx puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename; // Android fix
  puzzle_solutions_full_filename := puzzle_solutions_filename; // Android fix
  end;

// ShowMessage(puzzle_solutions_filename);

// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
// if(Length(puzzle_solutions_full_filename.Text) = 0) then
// ShowMessage('Error: file not found:' + LineEnding + puzzle_solutions_full_filename);
//-------------------------------

end; // else --> if(PlayerSelectComboBox.GetSelectedIndex() = 0) then


end;

procedure TPuzzleGameForm.PuzzleGameFormActivityResult(Sender: TObject;
  requestCode: integer; resultCode: TAndroidResult; intentData: jObject);
var
  n, n2, n3: Integer;

begin

    player_name_already_exists := 0;
    player_name := '';
    matching_solution_found := 0;



    if resultCode = RESULT_OK then
    begin

      if intentData = nil then
      begin
        ShowMessage('Error: intentData nil received.');
        Exit();
      end;



      if requestCode = OPEN_FILE then
      begin


        input_treeUri := jIntentManager1.GetDataUri(intentData);

        if input_treeUri = nil then
        begin
          ShowMessage('Error: Uri nil received.');
          Exit();
        end;

        input_filename := GetFileNameByUri(input_treeUri);



        //temp_puzzle_stringlist.Text := jFileProviderInternal.GetTextContent(input_filename);
        // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
        //if(Length(temp_puzzle_stringlist.Text) > 0) then
        //ShowMessage('File copied: ' + LineEnding + input_filename)
        //else
        //ShowMessage('CopyFileFromUri failed');


        player_name_already_exists := 0;

        for n := 1 to player_names_stringlist.Count - 1 do
        begin
          if (CompareStr(input_filename, (player_names_stringlist.Strings[n] + '.txt')) = 0) then
          begin
          player_name_already_exists := 1;
          break;
          end;
        end; // for n:= 0 to player_names_stringlist.Lines.Count-1 do


        player_name := Copy(input_filename, 1, Length(input_filename) - 4); // removes file extension '.txt'

        if(player_name_already_exists = 0) then
        begin
          CopyFileFromUri(input_treeUri, Self.GetEnvironmentDirectoryPath(dirInternalAppStorage)); // TEnvDirectory.dirInternalAppStorage;

          player_names_stringlist.Add(player_name);
          player_names_stringlist.Strings[0] := IntToStr(player_names_stringlist.Count - 1);
//          ShowMessage(player_names_stringlist.Text);
          player_names_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + 'puzzle_game_players.txt');

          LoadPlayerNames();

          ShowMessage(player_name + ' solutions file imported.');

        end // if(player_name_already_exists = 0) then
        else
        begin
           //ShowMessage(player_name + ' already exists in database.');

           new_merge_puzzle_stringlist.Text := GetTextFromUri(input_treeUri);
           old_merge_puzzle_stringlist.Text := jFileProviderInternal.GetTextContent(input_filename);


           merge_solution_mode := 1;
           jDialogYN1.Msg := 'Do you want to merge solutions of old and new files?';
           jDialogYN1.Title := player_name + ' already exists in database.';
           jDialogYN1.Show();

        end; // else -> if(player_name_already_exists = 0) then





        // https://forum.lazarus.freepascal.org/index.php/topic,71606.msg559116.html#msg559116
        // Solved my problem using following steps:
        //  Copy file to app’s internal or cache directory then upload it.
        //
        // CopyFileFromUri(jIntentManager1.GetDataUri(intentData), GetEnvironmentDirectoryPath(dirDownloads));
        // filePath := GetEnvironmentDirectoryPath(dirDownloads) + '/' + GetFileNameByUri(jIntentManager1.GetDataUri(intentData));
        //if FileExists(filePath) then
        //      HttpClient1.UploadFile('http://192.xx.xx.xx/webapi/uploadfile.php', filePath, 'fileupload')
        //    else
        //      ShowMessage('File does not exist at: ' + filePath);


      end; // if requestCode = OPEN_FILE



      if requestCode = SAVE_FILE then
      begin

        output_treeUri := jIntentManager1.GetDataUri(intentData);

        if output_treeUri = nil then
        begin
          ShowMessage('Error: Uri nil received.');
          Exit();
        end;


        saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);
        Self.SaveTextToUri(saved_all_puzzles_stringlist.Text, output_treeUri); // saves text to file

      end; // if requestCode = SAVE_FILE




    end; // if resultCode = RESULT_OK


end;

procedure TPuzzleGameForm.PuzzleGameFormClose(Sender: TObject);
begin

MoveToNearestSlotAnimationTimer.Enabled := false;
RotateToNearest60angleAnimationTimer.Enabled := false;
ShowSolutionsTimer.Enabled := false;


end;



(*

procedure TPuzzleGameForm.Piece11Click(Sender: TObject);
begin

  clicked_X := Mouse.CursorPos.X - piece11_left;
  clicked_Y := Mouse.CursorPos.Y - piece11_top;
  Piece11.Cursor := 2;

end;




procedure TPuzzleGameForm.Piece01MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 1;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece01_left;
  clicked_Y := Mouse.CursorPos.Y - piece01_top;
  Piece01.Cursor := 2;
  Piece01.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[0];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[0];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece01_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece01_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[0] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[0];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;


procedure TPuzzleGameForm.Piece01MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

    if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
    Exit();


  // https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
  // ssLeft -- Left mouse button pressed.
    if ((Shift = [ssLeft]) and not mouse_button_pressed) then
    begin
      mouse_button_pressed := true;

    end;

    if not (Shift = [ssLeft]) then
    begin
          mouse_button_pressed := false;
    end;


    if( mouse_button_pressed ) then
    begin
     if(rotation_mode = false) then
     begin
      piece01_top :=  Mouse.CursorPos.Y - clicked_Y;
      piece01_left := Mouse.CursorPos.X - clicked_X;
     end // if(rotation_mode = false)
     else if(rotation_mode = true) then
     begin

     distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece01_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
     distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece01_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
     if (piece_is_flipped[0] = true) then
     distance_x := - distance_x;

     distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

     if (distance_x = 0) and (distance_y > 0) then
     mouse_rotation_angle := 90
     else if (distance_x = 0) and (distance_y < 0) then
     mouse_rotation_angle := -90
     else
     mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

//       DebugLabel.Visible := true;
//       DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
   //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

    mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
     if(mouse_rotation_angle_difference > 180) then
     mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


    current_rotation_angle := Round(mouse_rotation_angle_difference);

    Exit();
    end;// if(rotation_mode = true)

    end; // if( mouse_button_pressed )



end;
*)

procedure TPuzzleGameForm.Piece01MouseUp(X, Y: Integer);
begin

    if(slideshow_mode = true) then
    Exit();

    //xx Piece01.Cursor := 1;

    if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
    Exit();

    if(rotation_mode = false) then
    begin
      current_slot := 0;
      ClearSlot(piece_slot_address[0]);
      piece_slot_address[0] := 0;

      if ((abs(slot_left[0] - piece01_left) < piece_half_size) and (abs(slot_top[0] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 1;

      if ((slot_content[0] <> 0) and (slot_content[0] <> 1)) then
      PlacePieceToStartPosition(slot_content[0]);

      slot_content[0] := 1;

      piece_slot_address[0] := 1;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[1] - piece01_left) < piece_half_size) and (abs(slot_top[1] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 2;

      if ((slot_content[1] <> 0) and (slot_content[1] <> 1)) then
      PlacePieceToStartPosition(slot_content[1]);

      slot_content[1] := 1;

      piece_slot_address[0] := 2;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[2] - piece01_left) < piece_half_size) and (abs(slot_top[2] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 3;

      if ((slot_content[2] <> 0)  and (slot_content[2] <> 1))then
      PlacePieceToStartPosition(slot_content[2]);

      slot_content[2] := 1;

      piece_slot_address[0] := 3;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[3] - piece01_left) < piece_half_size) and (abs(slot_top[3] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 4;

      if ((slot_content[3] <> 0) and (slot_content[3] <> 1)) then
      PlacePieceToStartPosition(slot_content[3]);

      slot_content[3] := 1;

      piece_slot_address[0] := 4;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[4] - piece01_left) < piece_half_size) and (abs(slot_top[4] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 5;

      if ((slot_content[4] <> 0)  and (slot_content[4] <> 1))then
      PlacePieceToStartPosition(slot_content[4]);

      slot_content[4] := 1;

      piece_slot_address[0] := 5;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[5] - piece01_left) < piece_half_size) and (abs(slot_top[5] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 6;

      if ((slot_content[5] <> 0) and (slot_content[5] <> 1)) then
      PlacePieceToStartPosition(slot_content[5]);

      slot_content[5] := 1;

      piece_slot_address[0] := 6;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[6] - piece01_left) < piece_half_size) and (abs(slot_top[6] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 7;

      if ((slot_content[6] <> 0) and (slot_content[6] <> 1)) then
      PlacePieceToStartPosition(slot_content[6]);

      slot_content[6] := 1;

      piece_slot_address[0] := 7;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[7] - piece01_left) < piece_half_size) and (abs(slot_top[7] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 8;

      if ((slot_content[7] <> 0) and (slot_content[7] <> 1)) then
      PlacePieceToStartPosition(slot_content[7]);

      slot_content[7] := 1;

      piece_slot_address[0] := 8;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[8] - piece01_left) < piece_half_size) and (abs(slot_top[8] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 9;

      if ((slot_content[8] <> 0) and (slot_content[8] <> 1)) then
      PlacePieceToStartPosition(slot_content[8]);

      slot_content[8] := 1;

      piece_slot_address[0] := 9;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[9] - piece01_left) < piece_half_size) and (abs(slot_top[9] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 10;

      if ((slot_content[9] <> 0) and (slot_content[9] <> 1)) then
      PlacePieceToStartPosition(slot_content[9]);

      slot_content[9] := 1;

      piece_slot_address[0] := 10;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[10] - piece01_left) < piece_half_size) and (abs(slot_top[10] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 11;

      if ((slot_content[10] <> 0) and (slot_content[10] <> 1)) then
      PlacePieceToStartPosition(slot_content[10]);

      slot_content[10] := 1;

      piece_slot_address[0] := 11;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[11] - piece01_left) < piece_half_size) and (abs(slot_top[11] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 12;

      if ((slot_content[11] <> 0) and (slot_content[11] <> 1)) then
      PlacePieceToStartPosition(slot_content[11]);

      slot_content[11] := 1;

      piece_slot_address[0] := 12;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end
      else if ((abs(slot_left[12] - piece01_left) < piece_half_size) and (abs(slot_top[12] - piece01_top ) < piece_half_size)) then
      begin
      current_slot := 13;

      if ((slot_content[12] <> 0) and (slot_content[12] <> 1)) then
      PlacePieceToStartPosition(slot_content[12]);

      slot_content[12] := 1;

      piece_slot_address[0] := 13;
      MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
      end;
    end // if(rotation_mode = false)
    else if(rotation_mode = true) then
    begin

    current_rotation_angle := Round(mouse_rotation_angle_difference);
    angle_6th_part := mouse_rotation_angle_difference / 60.0;
    final_rotation_angle := Round(angle_6th_part) * 60;
    piece_rotation_angle[0] := final_rotation_angle;
    RotateToNearest60angleAnimationTimer.Enabled := true;

    end; // else if(rotation_mode = true)



end;


(*
procedure TPuzzleGameForm.Piece02MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 2;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece02_left;
  clicked_Y := Mouse.CursorPos.Y - piece02_top;
  Piece02.Cursor := 2;
  Piece02.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[1];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[1];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece02_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece02_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[1] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[1];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece02MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece02_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece02_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece02_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece02_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[1] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )


end;
*)

procedure TPuzzleGameForm.Piece02MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece02.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[1]);
  piece_slot_address[1] := 0;


  if ((abs(slot_left[0] - piece02_left) < piece_half_size) and (abs(slot_top[0] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 2)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 2;

  piece_slot_address[1] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece02_left) < piece_half_size) and (abs(slot_top[1] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 2)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 2;

  piece_slot_address[1] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece02_left) < piece_half_size) and (abs(slot_top[2] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 2)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 2;

  piece_slot_address[1] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece02_left) < piece_half_size) and (abs(slot_top[3] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 2)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 2;

  piece_slot_address[1] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece02_left) < piece_half_size) and (abs(slot_top[4] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 2)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 2;

  piece_slot_address[1] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece02_left) < piece_half_size) and (abs(slot_top[5] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 2)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 2;

  piece_slot_address[1] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece02_left) < piece_half_size) and (abs(slot_top[6] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 2)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 2;

  piece_slot_address[1] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece02_left) < piece_half_size) and (abs(slot_top[7] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 2)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 2;

  piece_slot_address[1] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece02_left) < piece_half_size) and (abs(slot_top[8] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 2)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 2;

  piece_slot_address[1] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece02_left) < piece_half_size) and (abs(slot_top[9] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 2)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 2;

  piece_slot_address[1] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece02_left) < piece_half_size) and (abs(slot_top[10] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 2)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 2;

  piece_slot_address[1] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece02_left) < piece_half_size) and (abs(slot_top[11] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 2)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 2;

  piece_slot_address[1] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece02_left) < piece_half_size) and (abs(slot_top[12] - piece02_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 2)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 2;

  piece_slot_address[1] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[1] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)




end;

(*
procedure TPuzzleGameForm.Piece03MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 3;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece03_left;
  clicked_Y := Mouse.CursorPos.Y - piece03_top;
  Piece03.Cursor := 2;
  Piece03.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[2];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[2];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece03_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece03_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[2] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[2];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece03MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece03_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece03_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece03_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece03_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[2] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;
*)

procedure TPuzzleGameForm.Piece03MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece03.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[2]);
  piece_slot_address[2] := 0;


  if ((abs(slot_left[0] - piece03_left) < piece_half_size) and (abs(slot_top[0] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 3)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 3;

  piece_slot_address[2] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece03_left) < piece_half_size) and (abs(slot_top[1] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 3)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 3;

  piece_slot_address[2] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece03_left) < piece_half_size) and (abs(slot_top[2] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 3)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 3;

  piece_slot_address[2] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece03_left) < piece_half_size) and (abs(slot_top[3] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 3)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 3;

  piece_slot_address[2] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece03_left) < piece_half_size) and (abs(slot_top[4] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 3)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 3;

  piece_slot_address[2] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece03_left) < piece_half_size) and (abs(slot_top[5] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 3)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 3;

  piece_slot_address[2] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece03_left) < piece_half_size) and (abs(slot_top[6] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 3)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 3;

  piece_slot_address[2] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece03_left) < piece_half_size) and (abs(slot_top[7] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 3)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 3;

  piece_slot_address[2] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece03_left) < piece_half_size) and (abs(slot_top[8] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 3)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 3;

  piece_slot_address[2] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece03_left) < piece_half_size) and (abs(slot_top[9] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 3)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 3;

  piece_slot_address[2] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece03_left) < piece_half_size) and (abs(slot_top[10] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 3)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 3;

  piece_slot_address[2] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece03_left) < piece_half_size) and (abs(slot_top[11] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 3)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 3;

  piece_slot_address[2] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece03_left) < piece_half_size) and (abs(slot_top[12] - piece03_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 3)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 3;

  piece_slot_address[2] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[2] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)




end;


(*
procedure TPuzzleGameForm.Piece04MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 4;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece04_left;
  clicked_Y := Mouse.CursorPos.Y - piece04_top;
  Piece04.Cursor := 2;
  Piece04.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[3];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[3];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece04_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece04_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[3] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[3];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece04MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece04_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece04_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece04_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece04_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[3] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;
*)

procedure TPuzzleGameForm.Piece04MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece04.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[3]);
  piece_slot_address[3] := 0;


  if ((abs(slot_left[0] - piece04_left) < piece_half_size) and (abs(slot_top[0] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 4)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 4;

  piece_slot_address[3] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece04_left) < piece_half_size) and (abs(slot_top[1] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 4)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 4;

  piece_slot_address[3] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece04_left) < piece_half_size) and (abs(slot_top[2] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 4)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 4;

  piece_slot_address[3] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece04_left) < piece_half_size) and (abs(slot_top[3] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 4)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 4;

  piece_slot_address[3] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece04_left) < piece_half_size) and (abs(slot_top[4] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 4)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 4;

  piece_slot_address[3] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece04_left) < piece_half_size) and (abs(slot_top[5] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 4)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 4;

  piece_slot_address[3] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece04_left) < piece_half_size) and (abs(slot_top[6] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 4)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 4;

  piece_slot_address[3] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece04_left) < piece_half_size) and (abs(slot_top[7] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 4)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 4;

  piece_slot_address[3] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece04_left) < piece_half_size) and (abs(slot_top[8] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 4)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 4;

  piece_slot_address[3] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece04_left) < piece_half_size) and (abs(slot_top[9] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 4)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 4;

  piece_slot_address[3] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece04_left) < piece_half_size) and (abs(slot_top[10] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 4)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 4;

  piece_slot_address[3] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece04_left) < piece_half_size) and (abs(slot_top[11] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 4)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 4;

  piece_slot_address[3] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece04_left) < piece_half_size) and (abs(slot_top[12] - piece04_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 4)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 4;

  piece_slot_address[3] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[3] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)




end;

(*
procedure TPuzzleGameForm.Piece05MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 5;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece05_left;
  clicked_Y := Mouse.CursorPos.Y - piece05_top;
  Piece05.Cursor := 2;
  Piece05.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[4];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[4];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece05_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece05_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[4] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[4];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece05MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece05_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece05_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece05_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece05_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[4] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )




end;
*)


procedure TPuzzleGameForm.Piece05MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece05.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[4]);
  piece_slot_address[4] := 0;


  if ((abs(slot_left[0] - piece05_left) < piece_half_size) and (abs(slot_top[0] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 5)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 5;

  piece_slot_address[4] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece05_left) < piece_half_size) and (abs(slot_top[1] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 5)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 5;

  piece_slot_address[4] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece05_left) < piece_half_size) and (abs(slot_top[2] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 5)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 5;

  piece_slot_address[4] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece05_left) < piece_half_size) and (abs(slot_top[3] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 5)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 5;

  piece_slot_address[4] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece05_left) < piece_half_size) and (abs(slot_top[4] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 5)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 5;

  piece_slot_address[4] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece05_left) < piece_half_size) and (abs(slot_top[5] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 5)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 5;

  piece_slot_address[4] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece05_left) < piece_half_size) and (abs(slot_top[6] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 5)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 5;

  piece_slot_address[4] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece05_left) < piece_half_size) and (abs(slot_top[7] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 5)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 5;

  piece_slot_address[4] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece05_left) < piece_half_size) and (abs(slot_top[8] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 5)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 5;

  piece_slot_address[4] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece05_left) < piece_half_size) and (abs(slot_top[9] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 5)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 5;

  piece_slot_address[4] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece05_left) < piece_half_size) and (abs(slot_top[10] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 5)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 5;

  piece_slot_address[4] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece05_left) < piece_half_size) and (abs(slot_top[11] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 5)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 5;

  piece_slot_address[4] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece05_left) < piece_half_size) and (abs(slot_top[12] - piece05_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 5)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 5;

  piece_slot_address[4] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[4] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)




end;

(*
procedure TPuzzleGameForm.Piece06MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 6;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece06_left;
  clicked_Y := Mouse.CursorPos.Y - piece06_top;
  Piece06.Cursor := 2;
  Piece06.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[5];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[5];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece06_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece06_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[5] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[5];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece06MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece06_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece06_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece06_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece06_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[5] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )



end;
*)

procedure TPuzzleGameForm.Piece06MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece06.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[5]);
  piece_slot_address[5] := 0;


  if ((abs(slot_left[0] - piece06_left) < piece_half_size) and (abs(slot_top[0] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 6)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 6;

  piece_slot_address[5] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece06_left) < piece_half_size) and (abs(slot_top[1] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 6)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 6;

  piece_slot_address[5] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece06_left) < piece_half_size) and (abs(slot_top[2] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 6)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 6;

  piece_slot_address[5] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece06_left) < piece_half_size) and (abs(slot_top[3] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 6)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 6;

  piece_slot_address[5] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece06_left) < piece_half_size) and (abs(slot_top[4] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 6)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 6;

  piece_slot_address[5] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece06_left) < piece_half_size) and (abs(slot_top[5] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 6)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 6;

  piece_slot_address[5] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece06_left) < piece_half_size) and (abs(slot_top[6] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 6)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 6;

  piece_slot_address[5] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece06_left) < piece_half_size) and (abs(slot_top[7] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 6)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 6;

  piece_slot_address[5] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece06_left) < piece_half_size) and (abs(slot_top[8] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 6)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 6;

  piece_slot_address[5] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece06_left) < piece_half_size) and (abs(slot_top[9] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 6)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 6;

  piece_slot_address[5] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece06_left) < piece_half_size) and (abs(slot_top[10] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 6)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 6;

  piece_slot_address[5] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece06_left) < piece_half_size) and (abs(slot_top[11] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 6)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 6;

  piece_slot_address[5] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece06_left) < piece_half_size) and (abs(slot_top[12] - piece06_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 6)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 6;

  piece_slot_address[5] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[5] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)



end;


(*
procedure TPuzzleGameForm.Piece07MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 7;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece07_left;
  clicked_Y := Mouse.CursorPos.Y - piece07_top;
  Piece07.Cursor := 2;
  Piece07.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[6];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[6];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece07_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece07_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[6] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[6];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece07MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece07_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece07_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece07_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece07_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[6] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;

*)

procedure TPuzzleGameForm.Piece07MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece07.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[6]);
  piece_slot_address[6] := 0;


  if ((abs(slot_left[0] - piece07_left) < piece_half_size) and (abs(slot_top[0] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 7)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 7;

  piece_slot_address[6] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece07_left) < piece_half_size) and (abs(slot_top[1] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 7)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 7;

  piece_slot_address[6] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece07_left) < piece_half_size) and (abs(slot_top[2] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 7)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 7;

  piece_slot_address[6] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece07_left) < piece_half_size) and (abs(slot_top[3] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 7)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 7;

  piece_slot_address[6] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece07_left) < piece_half_size) and (abs(slot_top[4] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 7)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 7;

  piece_slot_address[6] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece07_left) < piece_half_size) and (abs(slot_top[5] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 7)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 7;

  piece_slot_address[6] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece07_left) < piece_half_size) and (abs(slot_top[6] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 7)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 7;

  piece_slot_address[6] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece07_left) < piece_half_size) and (abs(slot_top[7] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 7)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 7;

  piece_slot_address[6] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece07_left) < piece_half_size) and (abs(slot_top[8] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 7)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 7;

  piece_slot_address[6] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece07_left) < piece_half_size) and (abs(slot_top[9] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 7)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 7;

  piece_slot_address[6] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece07_left) < piece_half_size) and (abs(slot_top[10] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 7)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 7;

  piece_slot_address[6] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece07_left) < piece_half_size) and (abs(slot_top[11] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 7)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 7;

  piece_slot_address[6] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece07_left) < piece_half_size) and (abs(slot_top[12] - piece07_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 7)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 7;

  piece_slot_address[6] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[6] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)



end;


(*
procedure TPuzzleGameForm.Piece08MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 8;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece08_left;
  clicked_Y := Mouse.CursorPos.Y - piece08_top;
  Piece08.Cursor := 2;
  Piece08.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[7];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[7];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece08_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece08_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[7] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[7];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece08MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece08_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece08_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece08_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece08_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[7] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;
*)


procedure TPuzzleGameForm.Piece08MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece08.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[7]);
  piece_slot_address[7] := 0;


  if ((abs(slot_left[0] - piece08_left) < piece_half_size) and (abs(slot_top[0] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 8)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 8;

  piece_slot_address[7] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece08_left) < piece_half_size) and (abs(slot_top[1] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 8)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 8;

  piece_slot_address[7] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece08_left) < piece_half_size) and (abs(slot_top[2] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 8)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 8;

  piece_slot_address[7] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece08_left) < piece_half_size) and (abs(slot_top[3] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 8)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 8;

  piece_slot_address[7] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece08_left) < piece_half_size) and (abs(slot_top[4] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 8)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 8;

  piece_slot_address[7] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece08_left) < piece_half_size) and (abs(slot_top[5] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 8)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 8;

  piece_slot_address[7] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece08_left) < piece_half_size) and (abs(slot_top[6] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 8)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 8;

  piece_slot_address[7] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece08_left) < piece_half_size) and (abs(slot_top[7] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 8)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 8;

  piece_slot_address[7] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece08_left) < piece_half_size) and (abs(slot_top[8] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 8)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 8;

  piece_slot_address[7] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece08_left) < piece_half_size) and (abs(slot_top[9] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 8)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 8;

  piece_slot_address[7] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece08_left) < piece_half_size) and (abs(slot_top[10] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 8)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 8;

  piece_slot_address[7] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece08_left) < piece_half_size) and (abs(slot_top[11] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 8)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 8;

  piece_slot_address[7] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece08_left) < piece_half_size) and (abs(slot_top[12] - piece08_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 8)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 8;

  piece_slot_address[7] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[7] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)




end;


(*
procedure TPuzzleGameForm.Piece09MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 9;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece09_left;
  clicked_Y := Mouse.CursorPos.Y - piece09_top;
  Piece09.Cursor := 2;
  Piece09.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[8];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[8];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece09_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece09_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[8] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[8];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece09MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece09_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece09_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece09_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece09_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[8] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )




end;
*)

procedure TPuzzleGameForm.Piece09MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece09.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[8]);
  piece_slot_address[8] := 0;


  if ((abs(slot_left[0] - piece09_left) < piece_half_size) and (abs(slot_top[0] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 9)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 9;

  piece_slot_address[8] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece09_left) < piece_half_size) and (abs(slot_top[1] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 9)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 9;

  piece_slot_address[8] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece09_left) < piece_half_size) and (abs(slot_top[2] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 9)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 9;

  piece_slot_address[8] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece09_left) < piece_half_size) and (abs(slot_top[3] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 9)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 9;

  piece_slot_address[8] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece09_left) < piece_half_size) and (abs(slot_top[4] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 9)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 9;

  piece_slot_address[8] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece09_left) < piece_half_size) and (abs(slot_top[5] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 9)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 9;

  piece_slot_address[8] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece09_left) < piece_half_size) and (abs(slot_top[6] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 9)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 9;

  piece_slot_address[8] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece09_left) < piece_half_size) and (abs(slot_top[7] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 9)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 9;

  piece_slot_address[8] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece09_left) < piece_half_size) and (abs(slot_top[8] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 9)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 9;

  piece_slot_address[8] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece09_left) < piece_half_size) and (abs(slot_top[9] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 9)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 9;

  piece_slot_address[8] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece09_left) < piece_half_size) and (abs(slot_top[10] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 9)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 9;

  piece_slot_address[8] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece09_left) < piece_half_size) and (abs(slot_top[11] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 9)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 9;

  piece_slot_address[8] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece09_left) < piece_half_size) and (abs(slot_top[12] - piece09_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 9)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 9;

  piece_slot_address[8] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[8] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)



end;


(*
procedure TPuzzleGameForm.Piece10Click(Sender: TObject);
begin

end;

procedure TPuzzleGameForm.Piece10MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 10;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece10_left;
  clicked_Y := Mouse.CursorPos.Y - piece10_top;
  Piece10.Cursor := 2;
  Piece10.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[9];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[9];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece10_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece10_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[9] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[9];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece10MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece10_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece10_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece10_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece10_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[9] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;
*)

procedure TPuzzleGameForm.Piece10MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece10.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[9]);
  piece_slot_address[9] := 0;


  if ((abs(slot_left[0] - piece10_left) < piece_half_size) and (abs(slot_top[0] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 10)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 10;

  piece_slot_address[9] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece10_left) < piece_half_size) and (abs(slot_top[1] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 10)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 10;

  piece_slot_address[9] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece10_left) < piece_half_size) and (abs(slot_top[2] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 10)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 10;

  piece_slot_address[9] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece10_left) < piece_half_size) and (abs(slot_top[3] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 10)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 10;

  piece_slot_address[9] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece10_left) < piece_half_size) and (abs(slot_top[4] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 10)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 10;

  piece_slot_address[9] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece10_left) < piece_half_size) and (abs(slot_top[5] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 10)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 10;

  piece_slot_address[9] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece10_left) < piece_half_size) and (abs(slot_top[6] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 10)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 10;

  piece_slot_address[9] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece10_left) < piece_half_size) and (abs(slot_top[7] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 10)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 10;

  piece_slot_address[9] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece10_left) < piece_half_size) and (abs(slot_top[8] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 10)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 10;

  piece_slot_address[9] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece10_left) < piece_half_size) and (abs(slot_top[9] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 10)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 10;

  piece_slot_address[9] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece10_left) < piece_half_size) and (abs(slot_top[10] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 10)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 10;

  piece_slot_address[9] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece10_left) < piece_half_size) and (abs(slot_top[11] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 10)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 10;

  piece_slot_address[9] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece10_left) < piece_half_size) and (abs(slot_top[12] - piece10_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 10)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 10;

  piece_slot_address[9] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[9] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)



end;




(*
procedure TPuzzleGameForm.Piece11MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 11;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece11_left;
  clicked_Y := Mouse.CursorPos.Y - piece11_top;
  Piece11.Cursor := 2;
  Piece11.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[10];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[10];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece11_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece11_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[10] = true) then
  distance_x := - distance_x;

  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[10];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece11MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece11_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece11_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece11_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece11_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[10] = true) then
   distance_x := - distance_x;

   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )




end;
*)

procedure TPuzzleGameForm.Piece11MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece11.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[10]);
  piece_slot_address[10] := 0;


  if ((abs(slot_left[0] - piece11_left) < piece_half_size) and (abs(slot_top[0] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 11)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 11;

  piece_slot_address[10] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece11_left) < piece_half_size) and (abs(slot_top[1] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 11)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 11;

  piece_slot_address[10] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece11_left) < piece_half_size) and (abs(slot_top[2] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 11)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 11;

  piece_slot_address[10] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece11_left) < piece_half_size) and (abs(slot_top[3] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 11)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 11;

  piece_slot_address[10] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece11_left) < piece_half_size) and (abs(slot_top[4] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 11)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 11;

  piece_slot_address[10] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece11_left) < piece_half_size) and (abs(slot_top[5] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 11)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 11;

  piece_slot_address[10] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece11_left) < piece_half_size) and (abs(slot_top[6] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 11)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 11;

  piece_slot_address[10] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece11_left) < piece_half_size) and (abs(slot_top[7] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 11)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 11;

  piece_slot_address[10] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece11_left) < piece_half_size) and (abs(slot_top[8] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 11)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 11;

  piece_slot_address[10] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece11_left) < piece_half_size) and (abs(slot_top[9] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 11)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 11;

  piece_slot_address[10] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece11_left) < piece_half_size) and (abs(slot_top[10] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 11)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 11;

  piece_slot_address[10] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece11_left) < piece_half_size) and (abs(slot_top[11] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 11)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 11;

  piece_slot_address[10] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece11_left) < piece_half_size) and (abs(slot_top[12] - piece11_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 11)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 11;

  piece_slot_address[10] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[10] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)



end;


(*
procedure TPuzzleGameForm.Piece12MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 12;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece12_left;
  clicked_Y := Mouse.CursorPos.Y - piece12_top;
  Piece12.Cursor := 2;
  Piece12.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[11];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[11];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece12_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece12_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[11] = true) then
  distance_x := - distance_x;


  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[11];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece12MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece12_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece12_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece12_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece12_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[11] = true) then
   distance_x := - distance_x;


   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )




end;
*)


procedure TPuzzleGameForm.Piece12MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece12.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[11]);
  piece_slot_address[11] := 0;


  if ((abs(slot_left[0] - piece12_left) < piece_half_size) and (abs(slot_top[0] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 12)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 12;

  piece_slot_address[11] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece12_left) < piece_half_size) and (abs(slot_top[1] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 12)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 12;

  piece_slot_address[11] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece12_left) < piece_half_size) and (abs(slot_top[2] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 12)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 12;

  piece_slot_address[11] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece12_left) < piece_half_size) and (abs(slot_top[3] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 12)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 12;

  piece_slot_address[11] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece12_left) < piece_half_size) and (abs(slot_top[4] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 12)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 12;

  piece_slot_address[11] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece12_left) < piece_half_size) and (abs(slot_top[5] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 12)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 12;

  piece_slot_address[11] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece12_left) < piece_half_size) and (abs(slot_top[6] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 12)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 12;

  piece_slot_address[11] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece12_left) < piece_half_size) and (abs(slot_top[7] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 12)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 12;

  piece_slot_address[11] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece12_left) < piece_half_size) and (abs(slot_top[8] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 12)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 12;

  piece_slot_address[11] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece12_left) < piece_half_size) and (abs(slot_top[9] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 12)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 12;

  piece_slot_address[11] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece12_left) < piece_half_size) and (abs(slot_top[10] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 12)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 12;

  piece_slot_address[11] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece12_left) < piece_half_size) and (abs(slot_top[11] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 12)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 12;

  piece_slot_address[11] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece12_left) < piece_half_size) and (abs(slot_top[12] - piece12_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 12)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 12;

  piece_slot_address[11] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[11] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)


end;



(*
procedure TPuzzleGameForm.Piece13MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin

if(slideshow_mode = true) then
Exit();

  MoveToNearestSlotAnimationTimer.Enabled := false;
  RotateToNearest60angleAnimationTimer.Enabled := false;
  ErrorCircleImage.Visible := false;

  current_piece := 13;
  current_slot := piece_slot_address[current_piece-1];
  clicked_X := Mouse.CursorPos.X - piece13_left;
  clicked_Y := Mouse.CursorPos.Y - piece13_top;
  Piece13.Cursor := 2;
  Piece13.BringToFront();

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := piece_rotation_angle[12];
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  current_rotation_angle := piece_rotation_angle[12];

  distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece13_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
  distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece13_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
  if (piece_is_flipped[12] = true) then
  distance_x := - distance_x;

  distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

  if ( distance_r > piece_quarter_size) then
  begin
  rotation_mode := true;
  if (distance_x = 0) and (distance_y > 0) then
  mouse_rotation_angle_original := 90
  else if (distance_x = 0) and (distance_y < 0) then
  mouse_rotation_angle_original := -90
  else
  mouse_rotation_angle_original := radtodeg(ArcTan2(distance_y,distance_x));

  mouse_rotation_angle_original := mouse_rotation_angle_original - piece_rotation_angle[12];
  if(mouse_rotation_angle_original > 180) then
  mouse_rotation_angle_original := mouse_rotation_angle_original - 360;
  end// if(rotation_mode = true)
  else
  rotation_mode := false;

//    DebugLabel.Visible := true;
//    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
//    DebugLabel.Caption := FloatToStr(mouse_rotation_angle_original);

  RedrawAllPieces();

end;

procedure TPuzzleGameForm.Piece13MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

  if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
  Exit();


// https://www.freepascal.org/docs-html/rtl/classes/tshiftstate.html
// ssLeft -- Left mouse button pressed.
  if ((Shift = [ssLeft]) and not mouse_button_pressed) then
  begin
    mouse_button_pressed := true;

  end;

  if not (Shift = [ssLeft]) then
  begin
        mouse_button_pressed := false;
  end;


  if( mouse_button_pressed ) then
  begin
   if(rotation_mode = false) then
   begin
    piece13_top :=  Mouse.CursorPos.Y - clicked_Y;
    piece13_left := Mouse.CursorPos.X - clicked_X;
   end // if(rotation_mode = false)
   else if(rotation_mode = true) then
   begin

   distance_x := Mouse.CursorPos.X - PuzzleGameForm.Left - piece13_left - piece_half_size - mouseleft - 7; // cursor image size is 32x32, compensate for hotspot
   distance_y := Mouse.CursorPos.Y - PuzzleGameForm.Top - piece13_top - piece_half_size - mousetop - 7; // cursor image size is 32x32, compensate for hotspot
   if (piece_is_flipped[12] = true) then
   distance_x := - distance_x;

   distance_r := Round(Sqrt(distance_x*distance_x + distance_y*distance_y));

   if (distance_x = 0) and (distance_y > 0) then
   mouse_rotation_angle := 90
   else if (distance_x = 0) and (distance_y < 0) then
   mouse_rotation_angle := -90
   else
   mouse_rotation_angle := radtodeg(ArcTan2(distance_y,distance_x));

 //    DebugLabel.Visible := true;
 //    DebugLabel.Caption := IntToStr(distance_r) + ', ' + IntToStr(distance_x) + ', ' + IntToStr(distance_y) + ', ' + IntToStr(mouseleft) + ', ' + IntToStr(mousetop);
 //    DebugLabel.Caption := FloatToStr(mouse_rotation_angle);

  mouse_rotation_angle_difference := mouse_rotation_angle - mouse_rotation_angle_original;
   if(mouse_rotation_angle_difference > 180) then
   mouse_rotation_angle_difference := mouse_rotation_angle_difference - 360;


  current_rotation_angle := Round(mouse_rotation_angle_difference);

  Exit();
  end;// if(rotation_mode = true)

  end; // if( mouse_button_pressed )





end;
*)


procedure TPuzzleGameForm.Piece13MouseUp(X, Y: Integer);
begin

  if(slideshow_mode = true) then
  Exit();

//xx Piece13.Cursor := 1;

if ((MoveToNearestSlotAnimationTimer.Enabled = true) or (RotateToNearest60angleAnimationTimer.Enabled = true)) then
Exit();

if(rotation_mode = false) then
begin
  current_slot := 0;
  ClearSlot(piece_slot_address[12]);
  piece_slot_address[12] := 0;


  if ((abs(slot_left[0] - piece13_left) < piece_half_size) and (abs(slot_top[0] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 1;

  if ((slot_content[0] <> 0) and (slot_content[0] <> 13)) then
  PlacePieceToStartPosition(slot_content[0]);

  slot_content[0] := 13;

  piece_slot_address[12] := 1;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[1] - piece13_left) < piece_half_size) and (abs(slot_top[1] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 2;

  if ((slot_content[1] <> 0) and (slot_content[1] <> 13)) then
  PlacePieceToStartPosition(slot_content[1]);

  slot_content[1] := 13;

  piece_slot_address[12] := 2;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[2] - piece13_left) < piece_half_size) and (abs(slot_top[2] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 3;

  if ((slot_content[2] <> 0) and (slot_content[2] <> 13)) then
  PlacePieceToStartPosition(slot_content[2]);

  slot_content[2] := 13;

  piece_slot_address[12] := 3;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[3] - piece13_left) < piece_half_size) and (abs(slot_top[3] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 4;

  if ((slot_content[3] <> 0) and (slot_content[3] <> 13)) then
  PlacePieceToStartPosition(slot_content[3]);

  slot_content[3] := 13;

  piece_slot_address[12] := 4;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[4] - piece13_left) < piece_half_size) and (abs(slot_top[4] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 5;

  if ((slot_content[4] <> 0) and (slot_content[4] <> 13)) then
  PlacePieceToStartPosition(slot_content[4]);

  slot_content[4] := 13;

  piece_slot_address[12] := 5;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[5] - piece13_left) < piece_half_size) and (abs(slot_top[5] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 6;

  if ((slot_content[5] <> 0) and (slot_content[5] <> 13)) then
  PlacePieceToStartPosition(slot_content[5]);

  slot_content[5] := 13;

  piece_slot_address[12] := 6;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[6] - piece13_left) < piece_half_size) and (abs(slot_top[6] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 7;

  if ((slot_content[6] <> 0) and (slot_content[6] <> 13)) then
  PlacePieceToStartPosition(slot_content[6]);

  slot_content[6] := 13;

  piece_slot_address[12] := 7;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[7] - piece13_left) < piece_half_size) and (abs(slot_top[7] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 8;

  if ((slot_content[7] <> 0) and (slot_content[7] <> 13)) then
  PlacePieceToStartPosition(slot_content[7]);

  slot_content[7] := 13;

  piece_slot_address[12] := 8;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[8] - piece13_left) < piece_half_size) and (abs(slot_top[8] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 9;

  if ((slot_content[8] <> 0) and (slot_content[8] <> 13)) then
  PlacePieceToStartPosition(slot_content[8]);

  slot_content[8] := 13;

  piece_slot_address[12] := 9;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[9] - piece13_left) < piece_half_size) and (abs(slot_top[9] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 10;

  if ((slot_content[9] <> 0) and (slot_content[9] <> 13)) then
  PlacePieceToStartPosition(slot_content[9]);

  slot_content[9] := 13;

  piece_slot_address[12] := 10;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[10] - piece13_left) < piece_half_size) and (abs(slot_top[10] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 11;

  if ((slot_content[10] <> 0) and (slot_content[10] <> 13)) then
  PlacePieceToStartPosition(slot_content[10]);

  slot_content[10] := 13;

  piece_slot_address[12] := 11;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[11] - piece13_left) < piece_half_size) and (abs(slot_top[11] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 12;

  if ((slot_content[11] <> 0) and (slot_content[11] <> 13)) then
  PlacePieceToStartPosition(slot_content[11]);

  slot_content[11] := 13;

  piece_slot_address[12] := 12;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end
  else if ((abs(slot_left[12] - piece13_left) < piece_half_size) and (abs(slot_top[12] - piece13_top ) < piece_half_size)) then
  begin
      current_slot := 13;

  if ((slot_content[12] <> 0) and (slot_content[12] <> 13)) then
  PlacePieceToStartPosition(slot_content[12]);

  slot_content[12] := 13;

  piece_slot_address[12] := 13;
  MoveToNearestSlotAnimationTimerStartTimer(); MoveToNearestSlotAnimationTimer.Enabled := true;
  end;
end // if(rotation_mode = false)
else if(rotation_mode = true) then
begin

current_rotation_angle := Round(mouse_rotation_angle_difference);
angle_6th_part := mouse_rotation_angle_difference / 60.0;
final_rotation_angle := Round(angle_6th_part) * 60;
piece_rotation_angle[12] := final_rotation_angle;
RotateToNearest60angleAnimationTimer.Enabled := true;

end; // else if(rotation_mode = true)


end;









procedure TPuzzleGameForm.ConvertPieceSlotPositionIntoSlotContent(piece_slot_position: Integer; piece_number: Integer);
begin


if (piece_slot_position = 1) then
slot_content[0] := piece_number
else if (piece_slot_position = 2) then
slot_content[1] := piece_number
else if (piece_slot_position = 3) then
slot_content[2] := piece_number
else if (piece_slot_position = 4) then
slot_content[3] := piece_number
else if (piece_slot_position = 5) then
slot_content[4] := piece_number
else if (piece_slot_position = 6) then
slot_content[5] := piece_number
else if (piece_slot_position = 7) then
slot_content[6] := piece_number
else if (piece_slot_position = 8) then
slot_content[7] := piece_number
else if (piece_slot_position = 9) then
slot_content[8] := piece_number
else if (piece_slot_position = 10) then
slot_content[9] := piece_number
else if (piece_slot_position = 11) then
slot_content[10] := piece_number
else if (piece_slot_position = 12) then
slot_content[11] := piece_number
else if (piece_slot_position = 13) then
slot_content[12] := piece_number;


end;

procedure TPuzzleGameForm.LoadPiecesIntoBoard();
var
 n: Integer;
begin

 ClearBoard();

 if (saved_puzzle_stringlist.Count > 0) then
 piece_slot_address[0] := StrToIntDef(saved_puzzle_stringlist.Strings[0], 0)
 else
 piece_slot_address[0] := 0;

 if(piece_slot_address[0] > 0) and (piece_slot_address[0] < 14) then
 begin
 piece01_left := slot_left[piece_slot_address[0]-1];
 piece01_top := slot_top[piece_slot_address[0]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[0], 1);
 end
 else
 PlacePieceToStartPosition(1);


 if (saved_puzzle_stringlist.Count > 1) then
 piece_slot_address[1] := StrToIntDef(saved_puzzle_stringlist.Strings[1], 0)
 else
 piece_slot_address[1] := 0;

 if(piece_slot_address[1] > 0) and (piece_slot_address[1] < 14) then
 begin
 piece02_left := slot_left[piece_slot_address[1]-1];
 piece02_top := slot_top[piece_slot_address[1]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[1], 2);
 end
 else
 PlacePieceToStartPosition(2);


 if (saved_puzzle_stringlist.Count > 2) then
 piece_slot_address[2] := StrToIntDef(saved_puzzle_stringlist.Strings[2], 0)
 else
 piece_slot_address[2] := 0;

 if(piece_slot_address[2] > 0) and (piece_slot_address[2] < 14) then
 begin
 piece03_left := slot_left[piece_slot_address[2]-1];
 piece03_top := slot_top[piece_slot_address[2]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[2], 3);
 end
 else
 PlacePieceToStartPosition(3);


 if (saved_puzzle_stringlist.Count > 3) then
 piece_slot_address[3] := StrToIntDef(saved_puzzle_stringlist.Strings[3], 0)
 else
 piece_slot_address[3] := 0;

 if(piece_slot_address[3] > 0) and (piece_slot_address[3] < 14) then
 begin
 piece04_left := slot_left[piece_slot_address[3]-1];
 piece04_top := slot_top[piece_slot_address[3]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[3], 4);
 end
 else
 PlacePieceToStartPosition(4);


 if (saved_puzzle_stringlist.Count > 4) then
 piece_slot_address[4] := StrToIntDef(saved_puzzle_stringlist.Strings[4], 0)
 else
 piece_slot_address[4] := 0;

 if(piece_slot_address[4] > 0) and (piece_slot_address[4] < 14) then
 begin
 piece05_left := slot_left[piece_slot_address[4]-1];
 piece05_top := slot_top[piece_slot_address[4]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[4], 5);
 end
 else
 PlacePieceToStartPosition(5);


 if (saved_puzzle_stringlist.Count > 5) then
 piece_slot_address[5] := StrToIntDef(saved_puzzle_stringlist.Strings[5], 0)
 else
 piece_slot_address[5] := 0;

 if(piece_slot_address[5] > 0) and (piece_slot_address[5] < 14) then
 begin
 piece06_left := slot_left[piece_slot_address[5]-1];
 piece06_top := slot_top[piece_slot_address[5]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[5], 6);
 end
 else
 PlacePieceToStartPosition(6);


 if (saved_puzzle_stringlist.Count > 6) then
 piece_slot_address[6] := StrToIntDef(saved_puzzle_stringlist.Strings[6], 0)
 else
 piece_slot_address[6] := 0;

 if(piece_slot_address[6] > 0) and (piece_slot_address[6] < 14) then
 begin
 piece07_left := slot_left[piece_slot_address[6]-1];
 piece07_top := slot_top[piece_slot_address[6]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[6], 7);
 end
 else
 PlacePieceToStartPosition(7);


 if (saved_puzzle_stringlist.Count > 7) then
 piece_slot_address[7] := StrToIntDef(saved_puzzle_stringlist.Strings[7], 0)
 else
 piece_slot_address[7] := 0;

 if(piece_slot_address[7] > 0) and (piece_slot_address[7] < 14) then
 begin
 piece08_left := slot_left[piece_slot_address[7]-1];
 piece08_top := slot_top[piece_slot_address[7]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[7], 8);
 end
 else
 PlacePieceToStartPosition(8);


 if (saved_puzzle_stringlist.Count > 8) then
 piece_slot_address[8] := StrToIntDef(saved_puzzle_stringlist.Strings[8], 0)
 else
 piece_slot_address[8] := 0;

 if(piece_slot_address[8] > 0) and (piece_slot_address[8] < 14) then
 begin
 piece09_left := slot_left[piece_slot_address[8]-1];
 piece09_top := slot_top[piece_slot_address[8]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[8], 9);
 end
 else
 PlacePieceToStartPosition(9);


 if (saved_puzzle_stringlist.Count > 9) then
 piece_slot_address[9] := StrToIntDef(saved_puzzle_stringlist.Strings[9], 0)
 else
 piece_slot_address[9] := 0;

 if(piece_slot_address[9] > 0) and (piece_slot_address[9] < 14) then
 begin
 piece10_left := slot_left[piece_slot_address[9]-1];
 piece10_top := slot_top[piece_slot_address[9]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[9], 10);
 end
 else
 PlacePieceToStartPosition(10);


 if (saved_puzzle_stringlist.Count > 10) then
 piece_slot_address[10] := StrToIntDef(saved_puzzle_stringlist.Strings[10], 0)
 else
 piece_slot_address[10] := 0;

 if(piece_slot_address[10] > 0) and (piece_slot_address[10] < 14) then
 begin
 piece11_left := slot_left[piece_slot_address[10]-1];
 piece11_top := slot_top[piece_slot_address[10]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[10], 11);
 end
 else
 PlacePieceToStartPosition(11);


 if (saved_puzzle_stringlist.Count > 11) then
 piece_slot_address[11] := StrToIntDef(saved_puzzle_stringlist.Strings[11], 0)
 else
 piece_slot_address[11] := 0;

 if(piece_slot_address[11] > 0) and (piece_slot_address[11] < 14) then
 begin
 piece12_left := slot_left[piece_slot_address[11]-1];
 piece12_top := slot_top[piece_slot_address[11]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[11], 12);
 end
 else
 PlacePieceToStartPosition(12);


 if (saved_puzzle_stringlist.Count > 12) then
 piece_slot_address[12] := StrToIntDef(saved_puzzle_stringlist.Strings[12], 0)
 else
 piece_slot_address[12] := 0;

 if(piece_slot_address[12] > 0) and (piece_slot_address[12] < 14) then
 begin
 piece13_left := slot_left[piece_slot_address[12]-1];
 piece13_top := slot_top[piece_slot_address[12]-1];
 ConvertPieceSlotPositionIntoSlotContent(piece_slot_address[12], 13);
 end
 else
 PlacePieceToStartPosition(13);



 if (saved_puzzle_stringlist.Count > 13) then
 piece_rotation_angle[0] := StrToIntDef(saved_puzzle_stringlist.Strings[13], 0)
 else
 piece_rotation_angle[0] := 0;

 if (saved_puzzle_stringlist.Count > 14) then
 piece_rotation_angle[1] := StrToIntDef(saved_puzzle_stringlist.Strings[14], 0)
 else
 piece_rotation_angle[1] := 0;

 if (saved_puzzle_stringlist.Count > 15) then
 piece_rotation_angle[2] := StrToIntDef(saved_puzzle_stringlist.Strings[15], 0)
 else
 piece_rotation_angle[2] := 0;

 if (saved_puzzle_stringlist.Count > 16) then
 piece_rotation_angle[3] := StrToIntDef(saved_puzzle_stringlist.Strings[16], 0)
 else
 piece_rotation_angle[3] := 0;

 if (saved_puzzle_stringlist.Count > 17) then
 piece_rotation_angle[4] := StrToIntDef(saved_puzzle_stringlist.Strings[17], 0)
 else
 piece_rotation_angle[4] := 0;

 if (saved_puzzle_stringlist.Count > 18) then
 piece_rotation_angle[5] := StrToIntDef(saved_puzzle_stringlist.Strings[18], 0)
 else
 piece_rotation_angle[5] := 0;

 if (saved_puzzle_stringlist.Count > 19) then
 piece_rotation_angle[6] := StrToIntDef(saved_puzzle_stringlist.Strings[19], 0)
 else
 piece_rotation_angle[6] := 0;

 if (saved_puzzle_stringlist.Count > 20) then
 piece_rotation_angle[7] := StrToIntDef(saved_puzzle_stringlist.Strings[20], 0)
 else
 piece_rotation_angle[7] := 0;

 if (saved_puzzle_stringlist.Count > 21) then
 piece_rotation_angle[8] := StrToIntDef(saved_puzzle_stringlist.Strings[21], 0)
 else
 piece_rotation_angle[8] := 0;

 if (saved_puzzle_stringlist.Count > 22) then
 piece_rotation_angle[9] := StrToIntDef(saved_puzzle_stringlist.Strings[22], 0)
 else
 piece_rotation_angle[9] := 0;

 if (saved_puzzle_stringlist.Count > 23) then
 piece_rotation_angle[10] := StrToIntDef(saved_puzzle_stringlist.Strings[23], 0)
 else
 piece_rotation_angle[10] := 0;

 if (saved_puzzle_stringlist.Count > 24) then
 piece_rotation_angle[11] := StrToIntDef(saved_puzzle_stringlist.Strings[24], 0)
 else
 piece_rotation_angle[11] := 0;

 if (saved_puzzle_stringlist.Count > 25) then
 piece_rotation_angle[12] := StrToIntDef(saved_puzzle_stringlist.Strings[25], 0)
 else
 piece_rotation_angle[12] := 0;



 if (saved_puzzle_stringlist.Count > 26) then
 piece_is_flipped[0] := StrToBoolDef(saved_puzzle_stringlist.Strings[26], false)
 else
 piece_is_flipped[0] := false;

 if (saved_puzzle_stringlist.Count > 27) then
 piece_is_flipped[1] := StrToBoolDef(saved_puzzle_stringlist.Strings[27], false)
 else
 piece_is_flipped[1] := false;

 if (saved_puzzle_stringlist.Count > 28) then
 piece_is_flipped[2] := StrToBoolDef(saved_puzzle_stringlist.Strings[28], false)
 else
 piece_is_flipped[2] := false;

 if (saved_puzzle_stringlist.Count > 29) then
 piece_is_flipped[3] := StrToBoolDef(saved_puzzle_stringlist.Strings[29], false)
 else
 piece_is_flipped[3] := false;

 if (saved_puzzle_stringlist.Count > 30) then
 piece_is_flipped[4] := StrToBoolDef(saved_puzzle_stringlist.Strings[30], false)
 else
 piece_is_flipped[4] := false;

 if (saved_puzzle_stringlist.Count > 31) then
 piece_is_flipped[5] := StrToBoolDef(saved_puzzle_stringlist.Strings[31], false)
 else
 piece_is_flipped[5] := false;

 if (saved_puzzle_stringlist.Count > 32) then
 piece_is_flipped[6] := StrToBoolDef(saved_puzzle_stringlist.Strings[32], false)
 else
 piece_is_flipped[6] := false;

 if (saved_puzzle_stringlist.Count > 33) then
 piece_is_flipped[7] := StrToBoolDef(saved_puzzle_stringlist.Strings[33], false)
 else
 piece_is_flipped[7] := false;

 if (saved_puzzle_stringlist.Count > 34) then
 piece_is_flipped[8] := StrToBoolDef(saved_puzzle_stringlist.Strings[34], false)
 else
 piece_is_flipped[8] := false;

 if (saved_puzzle_stringlist.Count > 35) then
 piece_is_flipped[9] := StrToBoolDef(saved_puzzle_stringlist.Strings[35], false)
 else
 piece_is_flipped[9] := false;

 if (saved_puzzle_stringlist.Count > 36) then
 piece_is_flipped[10] := StrToBoolDef(saved_puzzle_stringlist.Strings[36], false)
 else
 piece_is_flipped[10] := false;

 if (saved_puzzle_stringlist.Count > 37) then
 piece_is_flipped[11] := StrToBoolDef(saved_puzzle_stringlist.Strings[37], false)
 else
 piece_is_flipped[11] := false;

 if (saved_puzzle_stringlist.Count > 38) then
 piece_is_flipped[12] := StrToBoolDef(saved_puzzle_stringlist.Strings[38], false)
 else
 piece_is_flipped[12] := false;



 if (saved_puzzle_stringlist.Count > 39) then
 date_and_time_string := saved_puzzle_stringlist.Strings[39]
 else
 date_and_time_string := 'date unknown';


 //xx ErrorCircleImage.Visible := false;
 if(inside_save_solution = false) then
 begin
   for n := 1 to 13 do
   PlacePieceIntoBoardToFindCollisions(n, piece_slot_address[n-1]);
 end; // if(inside_save_solution = false) then




end;

procedure TPuzzleGameForm.LoadNextSolution(slideshow_direction: Integer);
begin


// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
// if(Length(puzzle_solutions_full_filename.Text) = 0) then
//xx begin
//xx ShowSolutionsTimer.Enabled := false;
//xx ShowSavedSolutionsButton.Text := 'Show saved solutions';
//xx ShowMessage('Error: puzzle saved solutions file not found.' + LineEnding + puzzle_solutions_full_filename);
//xx Exit();
//xx end;


saved_all_puzzles_stringlist.Clear;
//xx saved_all_puzzles_stringlist.Strings.LoadFromFile(puzzle_solutions_full_filename);
saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);


if(saved_all_puzzles_stringlist.Count = 0) then
begin
ShowSavedSolutionsButtonClick(PuzzleGameForm);
Exit();
end;


if(slideshow_direction = 1) then
begin
  inc(saved_puzzle_number);
  if(saved_puzzle_number >= saved_all_puzzles_stringlist.Count) then
  saved_puzzle_number := 0;
end
else if(slideshow_direction = -1) then
begin
  dec(saved_puzzle_number);
  if(saved_puzzle_number < 0) then
  saved_puzzle_number := saved_all_puzzles_stringlist.Count-1;
end;


saved_puzzle_stringlist := TStringList.Create;
try
// https://www.freepascal.org/docs-html/rtl/classes/tstrings.delimitedtext.html
// DelimitedText returns all strings, properly quoted with QuoteChar and separated by the Delimiter character.
// Strings are quoted if they contain a space or any character with ASCII value less than 32.
// The CommaText property is a special case of delimited text where the delimiter character is a comma and the quote character is a double quote.
// If StrictDelimiter is set to True, then no quoting is done (The QuoteChar property is disregarded completely): the returned text will contain the items in the stringlist, separated by the Delimiter character. When writing the DelimitedText property, the text will be split at all occurrences of the Delimiter character; however, when reading, the QuoteChar property will be taken into account.

  saved_puzzle_stringlist.Delimiter := ';';
  // saved_puzzle_stringlist.StrictDelimiter := True;
  saved_puzzle_stringlist.DelimitedText := saved_all_puzzles_stringlist.Strings[saved_puzzle_number];

  LoadPiecesIntoBoard();

finally
  saved_puzzle_stringlist.Free;
end;



//OutputLabel.Text := IntToStr(saved_puzzle_number + 1) + ' from ' + IntToStr(saved_all_puzzles_stringlist.Count) + ' (total 1641 variants of solution exists)';
OutputLabel.Text := IntToStr(saved_puzzle_number + 1) + ' from ' + IntToStr(saved_all_puzzles_stringlist.Count);

DateLabel.Text := date_and_time_string;




current_piece := 0; // mantas bando



TableView.Refresh();



end;

procedure TPuzzleGameForm.ShowSavedSolutionsButtonClick(Sender: TObject);
begin



previous_current_piece := -1; // ?? maybe not needed
current_piece := 0;
//xx OutputLabel.Background.Color := TColor($566a85); // <<<-----  R and B colors are inverted RGB becomes BRG
//xx DateLabel.Background.Color := TColor($566a85); // <<<-----  R and B colors are inverted RGB becomes BRG


if (slideshow_mode = false) then
begin

  if(PlayerSelectComboBox.GetSelectedIndex() - 2 = 0) then
  OutputLabel.Text := 'Player’s solutions'
  else if(PlayerSelectComboBox.GetSelectedIndex() - 2 > 0) then
  OutputLabel.Text := player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2] + '’s solutions'
  else
  Exit();

DebugLabel.Text := '';
//xx ErrorCircleImage.Visible := false;
StartNewGame();
//OutputLabel.Caption := '';
//xx OutputImage.BringToFront();
//xx OutputLabel.BringToFront();
DateLabel.Text := '';
ShowSavedSolutionsButton.Text := 'Exit slideshow';

//xx if(CompareStr( player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2], 'Virginija') = 0) then
//xx OutputImage.Visible := true;

//xx OutputLabel.Visible := true;
//xx DateLabel.Visible := false;
//SaveButton.Enabled := true;
//xx Application.ProcessMessages;
//xx Sleep(3000);
end;


saved_puzzle_number := -1;

slideshow_mode := not slideshow_mode;


if (slideshow_mode = false) then
begin
ShowSolutionsTimer.Enabled := false;
ShowSavedSolutionsButton.Text := 'Show saved solutions';

ShowSavedSolutionsButton.Visible := false; // needs dublication of code because NewGameButtonClick(Self) fails to call this code
FlipButton.Text := 'Flip';  // needs dublication of code because NewGameButtonClick(Self) fails to call this code
Rot60MinusButton.Text := 'Rotate -60'; // needs dublication of code because NewGameButtonClick(Self) fails to call this code
Rot60PlusButton.Text := 'Rotate +60'; // needs dublication of code because NewGameButtonClick(Self) fails to call this code

//xx OutputImage.Visible := false;
//xx OutputLabel.Visible := false;
//xx DateLabel.Visible := false;
//TabLayout1.SetPosition(0);
NewGameButtonClick(Self);
end
else
begin
//-------------------------------
if ((PlayerSelectComboBox.GetSelectedIndex() - 2) > 0) then
begin
puzzle_solutions_filename := player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2] + '.txt';
//puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename; // Android fix
puzzle_solutions_full_filename := puzzle_solutions_filename; // Android fix
end
else
begin
puzzle_solutions_filename := 'Player.txt';
//puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename; // Android fix
puzzle_solutions_full_filename := puzzle_solutions_filename; // Android fix
end;

//ShowMessage(puzzle_solutions_filename);

// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
// if(Length(player_names_stringlist.Text) = 0) then
// ShowMessage('Error: file not found:' + LineEnding + puzzle_solutions_full_filename);
//-------------------------------

//ShowSavedSolutionsButton.Visible := true;

saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);
if(Length(saved_all_puzzles_stringlist.Text) > 0) then
begin
  TabLayout1.SetPosition(0);
  ShowSolutionsTimerTimer(Self); // start Timer code instantly without delay
  ShowSolutionsTimer.Enabled := true;
  ShowSavedSolutionsButton.Text := 'Exit slideshow';
end
else
begin
 slideshow_mode := false;
 redraw_pieces_after_simplify_solution := false;
 ShowSavedSolutionsButton.Text := 'Show saved solutions';
 ShowMessage('Number of saved solutions is zero.');
 Exit();
end;

//xx  if(CompareStr( player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2], 'Virginija') = 0) then
//xx  OutputImage.Visible := true;

//xx OutputLabel.Visible := true;
//xx DateLabel.Visible := true;
//DateLabel.Visible := false;
//SaveButton.Enabled := true;
end;






end;

procedure TPuzzleGameForm.NewGameButtonClick(Sender: TObject);
var
 n: Integer;
begin


if (ShowSolutionsTimer.Enabled = true) then
begin
ShowSavedSolutionsButtonClick(Sender);
end;



NewGameButton.Enabled := false;


congratulations_visible := 0;
error_circle_image_visible := 0;

DebugLabel.Text := '';
//xx ErrorCircleImage.Visible := false;

slideshow_mode := false;
redraw_pieces_after_simplify_solution := false;
previous_current_piece := -1;
current_piece := 0;
StartNewGame();


// Android Fix begin
saved_current_piece := 0;

for n := 1 to 13 do
begin
current_piece := n;
RotatePiece();
end;
current_piece := 0;
// Android Fix end



background_of_board_already_drawn := 0;

TableView.Refresh();



TableView.Enabled := true;
FlipButton.Enabled := true;
Rot60PlusButton.Enabled := true;
Rot60MinusButton.Enabled := true;


NewGameButton.Enabled := true;

TabLayout1.SetPosition(0);


TableView.OnTouchUp := @TableViewTouchUp;
TableView.OnTouchMove := @TableViewTouchMove;
TableView.OnTouchDown := @TableViewTouchDown;


end;

procedure TPuzzleGameForm.PieceRotationTrackBarProgressChanged(Sender: TObject;
  progress: integer; fromUser: boolean);
begin

  RotateToNearest60angleAnimationTimer.Enabled := false;
//xx  current_rotation_angle := PieceRotationTrackBar.Position;

  TableView.Refresh();

//DebugLabel.Caption := 'current_rotation_angle = ' + IntToStr(current_rotation_angle) + ', final_rotation_angle = ' + IntToStr(final_rotation_angle);

end;




procedure TPuzzleGameForm.AddDeletePlayerButtonClick(Sender: TObject);
var
 n: Integer;
begin

if(PlayerSelectComboBox.GetSelectedIndex() = 0) then // AddDeletePlayerButton.Caption := 'Add player';
begin
 if(CompareStr(PlayerNameEdit.Text, '') <> 0) then
 begin

  for n:= 0 to player_names_stringlist.Count-1 do
  begin
    if(CompareStr(PlayerNameEdit.Text, player_names_stringlist.Strings[n]) = 0) then
    begin
     ShowMessage('Player with ' + PlayerNameEdit.Text + ' name already exists.' + LineEnding + 'Please choose another name or delete old ' + PlayerNameEdit.Text + ' player.');
     Exit();
    end;
  end; // for n:= 0 to player_names_stringlist.Strings.Count-1 do

  PlayerSelectComboBox.Add(PlayerNameEdit.Text);
  PlayerSelectComboBox.SetSelectedIndex(PlayerSelectComboBox.Items.Count - 1);

  puzzle_solutions_filename := PlayerNameEdit.Text + '.txt';
  //puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename; // Android fix
  puzzle_solutions_full_filename := puzzle_solutions_filename; // Android fix

  // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
  empty_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + puzzle_solutions_full_filename);


  player_names_stringlist.Add(PlayerNameEdit.Text);
  player_names_stringlist.Strings[0] := IntToStr(PlayerSelectComboBox.Items.Count - 3);
  // player_names_full_filename
  player_names_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + 'puzzle_game_players.txt');

  AddDeletePlayerButton.Visible := false;
  ExportSavedSolutionsButton.Visible := false;
  ImportSavedSolutionsButton.Visible := false;
  PlayerNameEdit.Visible := false;
  PlayerNameLabel.Visible := false;

  FlipButton.Visible := true;
  NewGameButton.Visible := true;
  ShowSavedSolutionsButton.Visible := true;

 end;//if(CompareStr(PlayerNameEdit.Text, '') <> 0)

end
else if(PlayerSelectComboBox.GetSelectedIndex() = 1) then // AddDeletePlayerButton.Caption := 'Delete player';
begin

for n := 0 to player_names_stringlist.Count-1 do
begin

//  if(CompareText(PlayerNameEdit.Text, player_names_stringlist.Strings[n]) = 0) then  // Compare 2 ansistrings case insensitive.
  if(CompareStr(PlayerNameEdit.Text, player_names_stringlist.Strings[n]) = 0) then  // Compare 2 ansistrings case-sensitively, ignoring special characters.
  begin
//    ListBox1.Items.Delete(Index);
    player_names_stringlist.Delete(n);
    player_names_stringlist.Strings[0] := '0';
    // player_names_full_filename
    player_names_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + 'puzzle_game_players.txt');

    puzzle_solutions_filename := PlayerNameEdit.Text + '.txt';
    puzzle_solutions_full_filename := puzzle_solutions_filepath + puzzle_solutions_filename;

    // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
    //procedure DeleteFile(_environmentDir: TEnvDirectory; _filename: string); overload; //mode delphi!
    DeleteFile(dirInternalAppStorage, puzzle_solutions_full_filename);
//   player_names_stringlist.save


//     empty_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);
//     // in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
//     if(Length(empty_stringlist.Text) = 0) then
//     ShowMessage('Deletion success')
//     else
//     ShowMessage('Failed to delete');



    AddDeletePlayerButton.Visible := false;
    ExportSavedSolutionsButton.Visible := false;
    ImportSavedSolutionsButton.Visible := false;
    PlayerNameEdit.Visible := false;
    PlayerNameLabel.Visible := false;

    FlipButton.Visible := true;
    NewGameButton.Visible := true;
    ShowSavedSolutionsButton.Visible := true;

    ShowMessage('Player ' + PlayerNameEdit.Text + ' deleted.');

    LoadPlayerNames();

    Exit();
  end;
end; // for n:= 0 to player_names_stringlist.Strings.Count-1 do

ShowMessage('Unable to delete player with name ' + PlayerNameEdit.Text + '.' + LineEnding + PlayerNameEdit.Text + ' was not found.' + LineEnding + 'Hint: please write the name case-sensitive.');

end; // else if(PlayerSelectComboBox.GetSelectedIndex() = 1) // AddDeletePlayerButton.Caption := 'Delete player';


end;



procedure TPuzzleGameForm.ExportSavedSolutionsButtonClick(Sender: TObject);
begin


        //if IsRuntimePermissionGranted('android.permission.WRITE_EXTERNAL_STORAGE') then   //READ_EXTERNAL_STORAGE // if (targetSdkPlatform < 29)
      begin
        Self.RequestCreateFile(Self.GetEnvironmentDirectoryPath(dirDownloads),'text/plain', puzzle_solutions_filename, SAVE_FILE);   //handled by "OnActivityResult"
      end;
{
      else
      begin


      //https://www.captechconsulting.com/blogs/runtime-permissions-best-practices-and-how-to-gracefully-handle-permission-removal
      if IsRuntimePermissionNeed() then   // that is, target API >= 23
      begin
         ShowMessage('Requesting Runtime Permission....');
         Self.RequestRuntimePermission('android.permission.WRITE_EXTERNAL_STORAGE', 5001);  //from AndroodManifest.xml
      end;

      end;
}


end;


(*
procedure TPuzzleGameForm.ErrorCircleImageClick(Sender: TObject);
begin

end;

procedure TPuzzleGameForm.ErrorCircleImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin

ErrorCircleImage.Visible := false;

end;




procedure TPuzzleGameForm.ErrorCircleImageRedraw(Sender: TObject;
  Bitmap: TBGRABitmap);
begin

Bitmap.FillTransparent;
//  TColor($0000FF) is Red <<--- R and B colors are inverted RGB becomes BGR
Bitmap.EllipseAntialias(current_piece_marking_ellipse_radius + error_circle_pen_width_div_2, current_piece_marking_ellipse_radius + error_circle_pen_width_div_2, current_piece_marking_ellipse_radius, current_piece_marking_ellipse_radius, TColor($0000FF), error_circle_pen_width, BGRAPixelTransparent);


end;
*)


procedure TPuzzleGameForm.Piece01Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

  if(current_piece = 1) then
  begin
  Bitmap.FillTransparent;
  Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_01,current_rotation_angle,piece_image_01.Width/2-0.5,piece_image_01.Height/2-0.5);
  Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
  end
  else
  Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_01,piece_rotation_angle[0],piece_image_01.Width/2-0.5,piece_image_01.Height/2-0.5);

  if (piece_is_flipped[0]) then
  Bitmap.HorizontalFlip();

end;


procedure TPuzzleGameForm.Piece02Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 2) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_02,current_rotation_angle,piece_image_02.Width/2-0.5,piece_image_02.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_02,piece_rotation_angle[1],piece_image_02.Width/2-0.5,piece_image_02.Height/2-0.5);

    if (piece_is_flipped[1]) then
    Bitmap.HorizontalFlip();


end;

procedure TPuzzleGameForm.Piece03Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 3) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_03,current_rotation_angle,piece_image_03.Width/2-0.5,piece_image_03.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_03,piece_rotation_angle[2],piece_image_03.Width/2-0.5,piece_image_03.Height/2-0.5);

    if (piece_is_flipped[2]) then
    Bitmap.HorizontalFlip();

end;

procedure TPuzzleGameForm.Piece04Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 4) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_04,current_rotation_angle,piece_image_04.Width/2-0.5,piece_image_04.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_04,piece_rotation_angle[3],piece_image_04.Width/2-0.5,piece_image_04.Height/2-0.5);

    if (piece_is_flipped[3]) then
    Bitmap.HorizontalFlip();

end;

procedure TPuzzleGameForm.Piece05Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 5) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_05,current_rotation_angle,piece_image_05.Width/2-0.5,piece_image_05.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_05,piece_rotation_angle[4],piece_image_05.Width/2-0.5,piece_image_05.Height/2-0.5);

    if (piece_is_flipped[4]) then
    Bitmap.HorizontalFlip();

end;

procedure TPuzzleGameForm.Piece06Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 6) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.6,Bitmap.Height/2-0.6,piece_image_06,current_rotation_angle,piece_image_06.Width/2-0.6,piece_image_06.Height/2-0.6);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.6,Bitmap.Height/2-0.6,piece_image_06,piece_rotation_angle[5],piece_image_06.Width/2-0.6,piece_image_06.Height/2-0.6);

    if (piece_is_flipped[5]) then
    Bitmap.HorizontalFlip();


end;

procedure TPuzzleGameForm.Piece07Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 7) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_07,current_rotation_angle,piece_image_07.Width/2-0.5,piece_image_07.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_07,piece_rotation_angle[6],piece_image_07.Width/2-0.5,piece_image_07.Height/2-0.5);

    if (piece_is_flipped[6]) then
    Bitmap.HorizontalFlip();

end;

procedure TPuzzleGameForm.Piece08Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 8) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_08,current_rotation_angle,piece_image_08.Width/2-0.5,piece_image_08.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_08,piece_rotation_angle[7],piece_image_08.Width/2-0.5,piece_image_08.Height/2-0.5);

    if (piece_is_flipped[7]) then
    Bitmap.HorizontalFlip();

end;

procedure TPuzzleGameForm.Piece09Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 9) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_09,current_rotation_angle,piece_image_09.Width/2-0.5,piece_image_09.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_09,piece_rotation_angle[8],piece_image_09.Width/2-0.5,piece_image_09.Height/2-0.5);

    if (piece_is_flipped[8]) then
    Bitmap.HorizontalFlip();

end;



procedure TPuzzleGameForm.Piece10Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

  if(current_piece = 10) then
  begin
  Bitmap.FillTransparent;
  Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_10,current_rotation_angle,piece_image_10.Width/2-0.5,piece_image_10.Height/2-0.5);
  Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
  end
  else
  Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_10,piece_rotation_angle[9],piece_image_10.Width/2-0.5,piece_image_10.Height/2-0.5);

  if (piece_is_flipped[9]) then
  Bitmap.HorizontalFlip();

end;



procedure TPuzzleGameForm.Piece11Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 11) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_11,current_rotation_angle,piece_image_11.Width/2-0.5,piece_image_11.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_11,piece_rotation_angle[10],piece_image_11.Width/2-0.5,piece_image_11.Height/2-0.5);

    if (piece_is_flipped[10]) then
    Bitmap.HorizontalFlip();


end;




procedure TPuzzleGameForm.Piece12Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 12) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_12,current_rotation_angle,piece_image_12.Width/2-0.5,piece_image_12.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_12,piece_rotation_angle[11],piece_image_12.Width/2-0.5,piece_image_12.Height/2-0.5);

    if (piece_is_flipped[11]) then
    Bitmap.HorizontalFlip();


end;



procedure TPuzzleGameForm.Piece13Redraw(Sender: TObject; Bitmap: TBGRABitmap
  );
begin

    if(current_piece = 13) then
    begin
    Bitmap.FillTransparent;
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_13,current_rotation_angle,piece_image_13.Width/2-0.5,piece_image_13.Height/2-0.5);
    Bitmap.Canvas.Ellipse(current_piece_marking_ellipse_rect);
    end
    else
    Bitmap.PutImageAngle(Bitmap.Width/2-0.5,Bitmap.Height/2-0.5,piece_image_13,piece_rotation_angle[12],piece_image_13.Width/2-0.5,piece_image_13.Height/2-0.5);

    if (piece_is_flipped[12]) then
    Bitmap.HorizontalFlip();


end;










(*
procedure TPuzzleGameForm.PieceRotationTrackBarMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin

  current_rotation_angle := PieceRotationTrackBar.Position;
  angle_6th_part := PieceRotationTrackBar.Position / 60.0;
  final_rotation_angle := Round(angle_6th_part) * 60;

  PieceRotationTrackBar.OnChange := nil;
  PieceRotationTrackBar.Position := final_rotation_angle;
  PieceRotationTrackBar.OnChange := @PieceRotationTrackBarChange;

  RotateToNearest60angleAnimationTimer.Enabled := true;




end;
*)




procedure TPuzzleGameForm.RedrawAllPieces();
begin
  (*
  Piece01.RedrawBitmap;
  Piece02.RedrawBitmap;
  Piece03.RedrawBitmap;
  Piece04.RedrawBitmap;
  Piece05.RedrawBitmap;
  Piece06.RedrawBitmap;
  Piece07.RedrawBitmap;
  Piece08.RedrawBitmap;
  Piece09.RedrawBitmap;
  Piece10.RedrawBitmap;
  Piece11.RedrawBitmap;
  Piece12.RedrawBitmap;
  Piece13.RedrawBitmap;
 *)
end;




procedure TPuzzleGameForm.FixBugOfEmptySlot();
var
 n, n2: Integer;
 bug_empty_slot_found: Integer;
 buggy_slot_address: Integer;
 numbered_array: array [0..12] of Integer;
 missing_piece_slot_address: Integer;
begin

(*
// test array
piece_slot_address[0] := 4;
piece_slot_address[1] := 5;
piece_slot_address[2] := 13;
piece_slot_address[3] := 1;
piece_slot_address[4] := 11;
piece_slot_address[5] := 2;
piece_slot_address[6] := 12;
//piece_slot_address[7] := 10;
piece_slot_address[7] := 0;
piece_slot_address[8] := 3;
piece_slot_address[9] := 9;
piece_slot_address[10] := 8;
piece_slot_address[11] := 6;
piece_slot_address[12] := 7;
*)

bug_empty_slot_found := 0;
buggy_slot_address := 0;
missing_piece_slot_address := 0;

for n := 0 to 12 do
begin
 if (piece_slot_address[n] = 0) then
 begin
   bug_empty_slot_found := 1;
   buggy_slot_address := n;
   break;
 end; // if (piece_slot_address[n] = 0) then
end; // for n := 0 to 12




if(bug_empty_slot_found = 0) then
Exit();


for n := 0 to 12 do
begin
   numbered_array[n] := n+1;
end;



for n := 0 to 12 do
begin

  for n2 := 0 to 12 do
  begin
    if (numbered_array[n] = piece_slot_address[n2]) then
    numbered_array[n] := 0
  end; //for n2 := 0 to 12

end; //for n := 0 to 12


for n := 0 to 12 do
begin
   if (numbered_array[n] <> 0) then
   begin
    missing_piece_slot_address := numbered_array[n];
    piece_slot_address[buggy_slot_address] := missing_piece_slot_address;
    break;
   end;
end;


//ShowMessage('missing found = ' + IntToStr(piece_slot_address[buggy_slot_address]));



end;



procedure TPuzzleGameForm.SaveSolution();
var
 n, pos_n: Integer;
 old_solved_puzzle: String;
begin




if(slideshow_mode = true) then
Exit();


if(inside_save_solution = true) then
Exit();


if(redraw_pieces_after_simplify_solution = true) then
Exit();



inside_save_solution := true;


FlipButton.Visible := false;
Rot60PlusButton.Visible := false;
Rot60MinusButton.Visible := false;



SimplifySolution();


FixBugOfEmptySlot();




solved_puzzle_string := IntToStr(piece_slot_address[0]) + ';' + IntToStr(piece_slot_address[1]) + ';' + IntToStr(piece_slot_address[2]) + ';' + IntToStr(piece_slot_address[3]) + ';' + IntToStr(piece_slot_address[4]) + ';' + IntToStr(piece_slot_address[5]) + ';' + IntToStr(piece_slot_address[6]) + ';' + IntToStr(piece_slot_address[7]) + ';' + IntToStr(piece_slot_address[8]) + ';' + IntToStr(piece_slot_address[9]) + ';' + IntToStr(piece_slot_address[10]) + ';' + IntToStr(piece_slot_address[11]) + ';' + IntToStr(piece_slot_address[12]) + ';' + IntToStr(piece_rotation_angle[0]) + ';' + IntToStr(piece_rotation_angle[1]) + ';' + IntToStr(piece_rotation_angle[2]) + ';' + IntToStr(piece_rotation_angle[3]) + ';' + IntToStr(piece_rotation_angle[4]) + ';' + IntToStr(piece_rotation_angle[5]) + ';' + IntToStr(piece_rotation_angle[6]) + ';' + IntToStr(piece_rotation_angle[7]) + ';' + IntToStr(piece_rotation_angle[8]) + ';' + IntToStr(piece_rotation_angle[9]) + ';' + IntToStr(piece_rotation_angle[10]) + ';' + IntToStr(piece_rotation_angle[11]) + ';' + IntToStr(piece_rotation_angle[12]) + ';' + BoolToStr(piece_is_flipped[0]) + ';' + BoolToStr(piece_is_flipped[1]) + ';' + BoolToStr(piece_is_flipped[2]) + ';' + BoolToStr(piece_is_flipped[3]) + ';' + BoolToStr(piece_is_flipped[4]) + ';' + BoolToStr(piece_is_flipped[5]) + ';' + BoolToStr(piece_is_flipped[6]) + ';' + BoolToStr(piece_is_flipped[7]) + ';' + BoolToStr(piece_is_flipped[8]) + ';' + BoolToStr(piece_is_flipped[9]) + ';' + BoolToStr(piece_is_flipped[10]) + ';' + BoolToStr(piece_is_flipped[11]) + ';' + BoolToStr(piece_is_flipped[12]);


// old_solved_puzzle := Copy(saved_all_puzzles_stringlist.Strings.Strings[0], 1, Pos('"',saved_all_puzzles_stringlist.Strings.Strings[n]) - 2);
// MessageDlgEx(PCHAR(old_solved_puzzle), mtInformation, [mbOk], PuzzleGameForm);
// Exit();


saved_all_puzzles_stringlist.Clear;

// puzzle_solutions_filename := player_names_stringlist.Strings[PlayerSelectComboBox.GetSelectedIndex() - 2] + '.txt';  // visvien crash, nepadejo
// puzzle_solutions_full_filename := puzzle_solutions_filename;  // visvien crash, nepadejo

// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
// if(Length(puzzle_solutions_full_filename.Text) > 0) then causes crash
//xx saved_all_puzzles_stringlist.Strings.LoadFromFile(puzzle_solutions_full_filename);

if(player_names_loaded = 0) then
LoadPlayerNames();

saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);


old_solved_puzzle := '';

solution_already_exists := 0;
solution_already_exists_string_1 := '';
solution_already_exists_string_2 := '';
solution_already_exists_string_3 := '';


if(saved_all_puzzles_stringlist.Count > 0) then // protection
begin

for n := 0 to saved_all_puzzles_stringlist.Count-1 do
begin
  old_solved_puzzle := Copy(saved_all_puzzles_stringlist.Strings[n], 1, Pos('"',saved_all_puzzles_stringlist.Strings[n]) - 2);

  if (CompareStr(solved_puzzle_string, old_solved_puzzle) = 0) then
  begin
    pos_n := Pos('"',saved_all_puzzles_stringlist.Strings[n]) + 1;
    old_date_and_time_string := Copy(saved_all_puzzles_stringlist.Strings[n], pos_n, saved_all_puzzles_stringlist.Strings[n].Length - pos_n);

    solution_already_exists := 1;
    solution_already_exists_string_1 := 'This solution already exists';
    solution_already_exists_string_2 := 'in saved file as #' + IntToStr(n+1) + ' solution';
    solution_already_exists_string_3 := 'which was saved ' + old_date_and_time_string;
//    ShowMessage('This solution already exists in saved file as #' + IntToStr(n+1) + ' solution' + LineEnding +  'which was saved ' + old_date_and_time_string);
    RedrawAllPiecesAfterSimplifySolution();
    inside_save_solution := false;
    Exit();
  end;
end; // for n := 0 to saved_all_puzzles_stringlist.Count-1;

end;// if(saved_all_puzzles_stringlist.Count > 0) then



solved_puzzle_string := solved_puzzle_string + ';"' + date_and_time_string + '"';

saved_all_puzzles_stringlist.Add(solved_puzzle_string);
saved_all_puzzles_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + puzzle_solutions_full_filename);


ShowMessage('Solution saved.');

RedrawAllPiecesAfterSimplifySolution();
inside_save_solution := false;

TableView.OnTouchUp := @TableViewTouchUp;
TableView.OnTouchMove := @TableViewTouchMove;
TableView.OnTouchDown := @TableViewTouchDown;


end;




procedure TPuzzleGameForm.RedrawAllPiecesAfterSimplifySolution();
begin

// need to redraw all pieces after SimplifySolution() -- begin
saved_puzzle_stringlist := TStringList.Create;
try
// https://www.freepascal.org/docs-html/rtl/classes/tstrings.delimitedtext.html
// DelimitedText returns all strings, properly quoted with QuoteChar and separated by the Delimiter character.
// Strings are quoted if they contain a space or any character with ASCII value less than 32.
// The CommaText property is a special case of delimited text where the delimiter character is a comma and the quote character is a double quote.
// If StrictDelimiter is set to True, then no quoting is done (The QuoteChar property is disregarded completely): the returned text will contain the items in the stringlist, separated by the Delimiter character. When writing the DelimitedText property, the text will be split at all occurrences of the Delimiter character; however, when reading, the QuoteChar property will be taken into account.

  saved_puzzle_stringlist.Delimiter := ';';
  // saved_puzzle_stringlist.StrictDelimiter := True;
  saved_puzzle_stringlist.DelimitedText := solved_puzzle_string;


  LoadPiecesIntoBoard();

finally
  saved_puzzle_stringlist.Free;
end;

redraw_pieces_after_simplify_solution := true; // will force to rotate pieces during TableView.Refresh()
//slideshow_mode := true; // will force to rotate pieces during TableView.Refresh() and will lock up screen, will disable touching of screen
TableView.Refresh(); // will draw wihout white dot when slideshow_mode := true
//slideshow_mode := false; // <<-- important: do not do that, otherwise pieces will stay not rotated

// need to redraw all pieces after SimplifySolution() -- end
end;


procedure TPuzzleGameForm.FixButtonClick(Sender: TObject);
var
  n: Integer;
begin

(*


// in Android if file is not found then GetTextContent Result := ''; -- unable to find if file does not exits
if(Length(player_names_stringlist.Text) > 0) then
begin
DeleteFile(puzzle_solutions_full_filename);
CopyFile(puzzle_solutions_filename, puzzle_solutions_full_filename);
end;



saved_all_puzzles_stringlist.Clear;
//xx saved_all_puzzles_stringlist.Strings.LoadFromFile(puzzle_solutions_full_filename);
saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(puzzle_solutions_full_filename);

fixed_puzzle_stringlist.Clear;

for saved_puzzle_number := 0 to saved_all_puzzles_stringlist.Count-1 do
begin
solution_already_exists := 0;

saved_puzzle_stringlist := TStringList.Create;
try

  if (saved_all_puzzles_stringlist.Strings[saved_puzzle_number].Length <> 0) then
  begin

  saved_puzzle_stringlist.Delimiter := ';';
  saved_puzzle_stringlist.DelimitedText := saved_all_puzzles_stringlist.Strings[saved_puzzle_number];

  //===========================

piece_slot_address[0] := StrToIntDef(saved_puzzle_stringlist.Strings[0], 0);
piece_slot_address[1] := StrToIntDef(saved_puzzle_stringlist.Strings[1], 0);
piece_slot_address[2] := StrToIntDef(saved_puzzle_stringlist.Strings[2], 0);
piece_slot_address[3] := StrToIntDef(saved_puzzle_stringlist.Strings[3], 0);
piece_slot_address[4] := StrToIntDef(saved_puzzle_stringlist.Strings[4], 0);
piece_slot_address[5] := StrToIntDef(saved_puzzle_stringlist.Strings[5], 0);
piece_slot_address[6] := StrToIntDef(saved_puzzle_stringlist.Strings[6], 0);
piece_slot_address[7] := StrToIntDef(saved_puzzle_stringlist.Strings[7], 0);
piece_slot_address[8] := StrToIntDef(saved_puzzle_stringlist.Strings[8], 0);
piece_slot_address[9] := StrToIntDef(saved_puzzle_stringlist.Strings[9], 0);
piece_slot_address[10] := StrToIntDef(saved_puzzle_stringlist.Strings[10], 0);
piece_slot_address[11] := StrToIntDef(saved_puzzle_stringlist.Strings[11], 0);
piece_slot_address[12] := StrToIntDef(saved_puzzle_stringlist.Strings[12], 0);


piece_rotation_angle[0] := StrToIntDef(saved_puzzle_stringlist.Strings[13], 0);
piece_rotation_angle[1] := StrToIntDef(saved_puzzle_stringlist.Strings[14], 0);
piece_rotation_angle[2] := StrToIntDef(saved_puzzle_stringlist.Strings[15], 0);
piece_rotation_angle[3] := StrToIntDef(saved_puzzle_stringlist.Strings[16], 0);
piece_rotation_angle[4] := StrToIntDef(saved_puzzle_stringlist.Strings[17], 0);
piece_rotation_angle[5] := StrToIntDef(saved_puzzle_stringlist.Strings[18], 0);
piece_rotation_angle[6] := StrToIntDef(saved_puzzle_stringlist.Strings[19], 0);
piece_rotation_angle[7] := StrToIntDef(saved_puzzle_stringlist.Strings[20], 0);
piece_rotation_angle[8] := StrToIntDef(saved_puzzle_stringlist.Strings[21], 0);
piece_rotation_angle[9] := StrToIntDef(saved_puzzle_stringlist.Strings[22], 0);
piece_rotation_angle[10] := StrToIntDef(saved_puzzle_stringlist.Strings[23], 0);
piece_rotation_angle[11] := StrToIntDef(saved_puzzle_stringlist.Strings[24], 0);
piece_rotation_angle[12] := StrToIntDef(saved_puzzle_stringlist.Strings[25], 0);


piece_is_flipped[0] := StrToBoolDef(saved_puzzle_stringlist.Strings[26], false);
piece_is_flipped[1] := StrToBoolDef(saved_puzzle_stringlist.Strings[27], false);
piece_is_flipped[2] := StrToBoolDef(saved_puzzle_stringlist.Strings[28], false);
piece_is_flipped[3] := StrToBoolDef(saved_puzzle_stringlist.Strings[29], false);
piece_is_flipped[4] := StrToBoolDef(saved_puzzle_stringlist.Strings[30], false);
piece_is_flipped[5] := StrToBoolDef(saved_puzzle_stringlist.Strings[31], false);
piece_is_flipped[6] := StrToBoolDef(saved_puzzle_stringlist.Strings[32], false);
piece_is_flipped[7] := StrToBoolDef(saved_puzzle_stringlist.Strings[33], false);
piece_is_flipped[8] := StrToBoolDef(saved_puzzle_stringlist.Strings[34], false);
piece_is_flipped[9] := StrToBoolDef(saved_puzzle_stringlist.Strings[35], false);
piece_is_flipped[10] := StrToBoolDef(saved_puzzle_stringlist.Strings[36], false);
piece_is_flipped[11] := StrToBoolDef(saved_puzzle_stringlist.Strings[37], false);
piece_is_flipped[12] := StrToBoolDef(saved_puzzle_stringlist.Strings[38], false);


 SimplifySolution();



//================
solved_puzzle_string := IntToStr(piece_slot_address[0]) + ';' + IntToStr(piece_slot_address[1]) + ';' + IntToStr(piece_slot_address[2]) + ';' + IntToStr(piece_slot_address[3]) + ';' + IntToStr(piece_slot_address[4]) + ';' + IntToStr(piece_slot_address[5]) + ';' + IntToStr(piece_slot_address[6]) + ';' + IntToStr(piece_slot_address[7]) + ';' + IntToStr(piece_slot_address[8]) + ';' + IntToStr(piece_slot_address[9]) + ';' + IntToStr(piece_slot_address[10]) + ';' + IntToStr(piece_slot_address[11]) + ';' + IntToStr(piece_slot_address[12]) + ';' + IntToStr(piece_rotation_angle[0]) + ';' + IntToStr(piece_rotation_angle[1]) + ';' + IntToStr(piece_rotation_angle[2]) + ';' + IntToStr(piece_rotation_angle[3]) + ';' + IntToStr(piece_rotation_angle[4]) + ';' + IntToStr(piece_rotation_angle[5]) + ';' + IntToStr(piece_rotation_angle[6]) + ';' + IntToStr(piece_rotation_angle[7]) + ';' + IntToStr(piece_rotation_angle[8]) + ';' + IntToStr(piece_rotation_angle[9]) + ';' + IntToStr(piece_rotation_angle[10]) + ';' + IntToStr(piece_rotation_angle[11]) + ';' + IntToStr(piece_rotation_angle[12]) + ';' + BoolToStr(piece_is_flipped[0]) + ';' + BoolToStr(piece_is_flipped[1]) + ';' + BoolToStr(piece_is_flipped[2]) + ';' + BoolToStr(piece_is_flipped[3]) + ';' + BoolToStr(piece_is_flipped[4]) + ';' + BoolToStr(piece_is_flipped[5]) + ';' + BoolToStr(piece_is_flipped[6]) + ';' + BoolToStr(piece_is_flipped[7]) + ';' + BoolToStr(piece_is_flipped[8]) + ';' + BoolToStr(piece_is_flipped[9]) + ';' + BoolToStr(piece_is_flipped[10]) + ';' + BoolToStr(piece_is_flipped[11]) + ';' + BoolToStr(piece_is_flipped[12]);


for n := 0 to fixed_puzzle_stringlist.Lines.Count-1 do
begin
  if (CompareStr(solved_puzzle_string, fixed_puzzle_stringlist.Lines.Strings[n]) = 0) then
  begin
    MessageDlgEx(PCHAR('#' + IntToStr(saved_puzzle_number) + ' solution already exists in saved file as #' + IntToStr(n+1) + ' solution.'), mtInformation, [mbOk], PuzzleGameForm);
    solution_already_exists := 1;
//    SaveButton.Enabled := true;
//    Exit();
  end;
end; // for n := 0 to saved_all_puzzles_stringlist.Count-1;
//================


if(solution_already_exists = 0) then
fixed_puzzle_stringlist.Lines.Add(solved_puzzle_string);


end; //  if (saved_all_puzzles_stringlist.Strings[saved_puzzle_number].Length <> 0)

finally
  saved_puzzle_stringlist.Free;
end;

end;//for saved_puzzle_number := 0 to saved_all_puzzles_stringlist.Count-1 do


fixed_puzzle_stringlist.Lines.SaveToFile('fixed.txt');



ShowMessage('Saved solutions fixed.');

*)
end;



procedure TPuzzleGameForm.FlipButtonClick(Sender: TObject);
begin




// ShowMessage('top = ' + IntToStr(TableView.Top));  // 49
(*
function  GetScreenSize(): string;
function  GetScreenDensity(): string; overload;
function  GetScreenRealSizeInInches(): double;
function  GetScreenDpi(): integer;
function  GetScreenRealXdpi(): double;
function  GetScreenRealYdpi(): double;
function  GetScreenDensity(strDensity: string): integer; overload;
procedure SetDensityAssets( _value : TDensityAssets ); // by ADiV
*)

(*
ShowMessage('screen_density_rescale = ' + FloatToStr(screen_density_rescale) + LineEnding // Tablet Galaxy Tab A (2016) = 1.05625, Samsung Galaxy S3 = 2, Samsung Galaxy S9 = 4
+ 'GetScreenDensity() = ' + IntToStr(GetScreenDensity(GetScreenDensity())) + LineEnding // S9 Phone = xxx, Tablet Galaxy Tab A (2016) = 180
+ 'status_bar_height = ' + IntToStr(status_bar_height) + LineEnding  // S9 Phone = 96, Tablet = 27
+ 'TabLayout.GetLParamHeight = ' + IntToStr(TabLayout1.GetLParamHeight()) + LineEnding // S9 Phone = 192, Tablet = 54  // layout height and width at run time android
+ 'PIECE_SIZE = ' + IntToStr(PIECE_SIZE) + LineEnding    // S9 Phone = 360, Tablet = 225
+ 'TabLayout.GetHeight = ' + IntToStr(TabLayout1.GetHeight()) + LineEnding // S9 Phone = 49, Tablet =  49
+ 'board_offset_y_for_table_draw = ' + IntToStr(board_offset_y_for_table_draw) + LineEnding  // S9 Phone = 348, Tablet = 213
+ 'board_offset_y = ' + IntToStr(board_offset_y)); // S9 Phone = xxx, Tablet = xxx
Exit();
*)

//TabLayout1.LayoutParamHeight := ;



// need to redraw all pieces after SimplifySolution() -- begin
// needs NewGameButton click at first

(*
if(redraw_pieces_after_simplify_solution = true) then
begin
redraw_pieces_after_simplify_solution := false;
ShowMessage('redraw_pieces_after_simplify_solution disabled');
Exit();
end;



saved_puzzle_stringlist := TStringList.Create;
try
// https://www.freepascal.org/docs-html/rtl/classes/tstrings.delimitedtext.html
// DelimitedText returns all strings, properly quoted with QuoteChar and separated by the Delimiter character.
// Strings are quoted if they contain a space or any character with ASCII value less than 32.
// The CommaText property is a special case of delimited text where the delimiter character is a comma and the quote character is a double quote.
// If StrictDelimiter is set to True, then no quoting is done (The QuoteChar property is disregarded completely): the returned text will contain the items in the stringlist, separated by the Delimiter character. When writing the DelimitedText property, the text will be split at all occurrences of the Delimiter character; however, when reading, the QuoteChar property will be taken into account.

  saved_puzzle_stringlist.Delimiter := ';';
  // saved_puzzle_stringlist.StrictDelimiter := True;
//  saved_puzzle_stringlist.DelimitedText := '1;10;4;9;12;13;3;5;7;2;11;6;8;0;180;60;0;0;300;0;240;180;120;0;60;180;0;0;0;0;0;0;0;-1;0;0;0;0;0;"2025-11-08   14:47"';
  saved_puzzle_stringlist.DelimitedText := '1;10;4;9;12;13;3;5;7;2;11;0;0;0;180;60;0;0;300;0;240;180;120;0;60;180;0;0;0;0;0;0;0;-1;0;0;0;0;0;"2025-11-08   14:47"';



  LoadPiecesIntoBoard();

finally
  saved_puzzle_stringlist.Free;
end;

redraw_pieces_after_simplify_solution := true; // will force to rotate pieces during TableView.Refresh()
//slideshow_mode := true; // will force to rotate pieces during TableView.Refresh() and will lock up screen, will disable touching of screen
TableView.Refresh(); // will draw wihout white dot when slideshow_mode := true
//slideshow_mode := false; // <<-- important: do not do that, otherwise pieces will stay not rotated

TableView.OnTouchUp := @TableViewTouchUp;
TableView.OnTouchMove := @TableViewTouchMove;
TableView.OnTouchDown := @TableViewTouchDown;

ShowMessage('Solution loaded for test');
Exit();
// need to redraw all pieces after SimplifySolution() -- end
*)



//congratulations_visible := 1;
//TableView.Refresh();



 if(slideshow_mode = true) then
 begin
 ShowSolutionsTimer.Enabled := not ShowSolutionsTimer.Enabled;

 if(ShowSolutionsTimer.Enabled = true) then
 FlipButton.Text := 'Pause'
 else
 FlipButton.Text := 'Run';

 Exit();
 end;


 if(MoveToNearestSlotAnimationTimer.Enabled = true) then // workaround solution for: while piece is moving, click outside board and piece disappears.
 Exit();

 TableView.Enabled := false;
 FlipButton.Enabled := false;
 Rot60PlusButton.Enabled := false;
 Rot60MinusButton.Enabled := false;




if(current_piece < 1) then
current_piece := saved_current_piece;

if(current_piece < 1) then
begin
ShowMessage('Please select piece for flipping');
Exit();
end;



piece_is_flipped[current_piece-1] := not piece_is_flipped[current_piece-1];

PlacePieceIntoBoardToFindCollisions(current_piece, current_slot);

date_and_time_string := '';




if (current_piece = 1) then
piece01BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece01BitmapRotated.GetImage()))
else if (current_piece = 2) then
piece02BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece02BitmapRotated.GetImage()))
else if (current_piece = 3) then
piece03BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece03BitmapRotated.GetImage()))
else if (current_piece = 4) then
piece04BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece04BitmapRotated.GetImage()))
else if (current_piece = 5) then
piece05BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece05BitmapRotated.GetImage()))
else if (current_piece = 6) then
piece06BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece06BitmapRotated.GetImage()))
else if (current_piece = 7) then
piece07BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece07BitmapRotated.GetImage()))
else if (current_piece = 8) then
piece08BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece08BitmapRotated.GetImage()))
else if (current_piece = 9) then
piece09BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece09BitmapRotated.GetImage()))
else if (current_piece = 10) then
piece10BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece10BitmapRotated.GetImage()))
else if (current_piece = 11) then
piece11BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece11BitmapRotated.GetImage()))
else if (current_piece = 12) then
piece12BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece12BitmapRotated.GetImage()))
else if (current_piece = 13) then
piece13BitmapRotated.SetImage(jBitmap1.FlipHorizontal(piece13BitmapRotated.GetImage()));



previous_current_piece := 0;
//if((current_piece > 0) and (previous_current_piece <> current_piece)) then
TableView.Refresh();


if (MoveToNearestSlotAnimationTimer.Enabled = false) then
begin
  TableView.Enabled := true;
  FlipButton.Enabled := true;
  Rot60PlusButton.Enabled := true;
  Rot60MinusButton.Enabled := true;
end;

end;

procedure TPuzzleGameForm.ImportSavedSolutionsButtonClick(Sender: TObject);
begin


  //if IsRuntimePermissionGranted('android.permission.WRITE_EXTERNAL_STORAGE') then   //READ_EXTERNAL_STORAGE // if (targetSdkPlatform < 29)
  begin
    Self.RequestOpenFile(Self.GetEnvironmentDirectoryPath(dirDownloads), 'text/plain', OPEN_FILE); //handled by "OnActivityResult"
  end;
{
  else
  begin


  //https://www.captechconsulting.com/blogs/runtime-permissions-best-practices-and-how-to-gracefully-handle-permission-removal
  if IsRuntimePermissionNeed() then   // that is, target API >= 23
  begin
     ShowMessage('Requesting Runtime Permission....');
     Self.RequestRuntimePermission('android.permission.WRITE_EXTERNAL_STORAGE', 5001);  //from AndroodManifest.xml
  end;

  end;
}




end;

procedure TPuzzleGameForm.jDialogYN1ClickYN(Sender: TObject; YN: TClickYN);
var
  n, n2, n3: Integer;
begin

case YN of
  ClickYes :
    begin
      if(merge_solution_mode = 0) then
      begin
        can_close := true;
        Close();
        //Self.Close;
      end
      else
      begin

        solved_puzzle_1 := '';
        solved_puzzle_2 := '';
        solved_puzzle_2_with_date := '';
        difference_merge_puzzle_stringlist.Clear();

        for n2 := 0 to new_merge_puzzle_stringlist.Count-1 do
        begin

          matching_solution_found := 0;
          solved_puzzle_2_with_date := new_merge_puzzle_stringlist.Strings[n2];
          solved_puzzle_2 := '';
          solved_puzzle_2 := Copy(new_merge_puzzle_stringlist.Strings[n2], 1, Pos('"',new_merge_puzzle_stringlist.Strings[n2]) - 2); // without last character [;]

          for n := 0 to old_merge_puzzle_stringlist.Count-1 do
          begin

            solved_puzzle_1 := '';
            solved_puzzle_1 := Copy(old_merge_puzzle_stringlist.Strings[n], 1, Pos('"',old_merge_puzzle_stringlist.Strings[n]) - 2); // without last character [;]

            if(CompareStr(solved_puzzle_1, solved_puzzle_2) = 0) then
            begin
              matching_solution_found := 1;
              break;
            end; // if(CompareStr(solved_puzzle_1, solved_puzzle_2) = 0) then

          end; // for n := 0 to old_merge_puzzle_stringlist.Count-1 do


          if(matching_solution_found = 0) then
          begin
            // ShowMessage('added' + LineEnding + LineEnding + solved_puzzle_1 + LineEnding + LineEnding + solved_puzzle_2);
            // ShowMessage('added' + LineEnding + LineEnding + solved_puzzle_2_with_date);
            //difference_merge_puzzle_stringlist.Add(new_merge_puzzle_stringlist.Strings[n2]);
            difference_merge_puzzle_stringlist.Add(solved_puzzle_2_with_date);
          end;


        end; // for n2 := 0 to new_merge_puzzle_stringlist.Count-1 do


        if(difference_merge_puzzle_stringlist.Count = 0) then
        begin
          ShowMessage('No new solutions found in import file.');
          Exit();
        end;


        if(difference_merge_puzzle_stringlist.Count > 0) then
        begin
          for n3 := 0 to difference_merge_puzzle_stringlist.Count-1 do
          begin
            old_merge_puzzle_stringlist.Add(difference_merge_puzzle_stringlist.Strings[n3]);
          end;
        end; // if(difference_merge_puzzle_stringlist.Count > 0) then



        sorted_merge_puzzle_stringlist.Clear();
        pos_of_quotes := 0;
        date_and_time_string := '';
        for n := 0 to old_merge_puzzle_stringlist.Count-1 do
        begin
          pos_of_quotes := Pos('"',old_merge_puzzle_stringlist.Strings[n]) - 1;  // with last character [;]
          solved_puzzle_1 := Copy(old_merge_puzzle_stringlist.Strings[n], 1, pos_of_quotes);
          date_and_time_string := Copy(old_merge_puzzle_stringlist.Strings[n], pos_of_quotes + 1, Length(old_merge_puzzle_stringlist.Strings[n]) - pos_of_quotes);
          sorted_merge_puzzle_stringlist.Add(date_and_time_string + solved_puzzle_1);
        end; // for n := 0 to old_merge_puzzle_stringlist.Count-1 do


        sorted_merge_puzzle_stringlist.Sort();

        old_merge_puzzle_stringlist.Clear();
        for n := 0 to sorted_merge_puzzle_stringlist.Count-1 do
        begin
          temp_string := Copy(sorted_merge_puzzle_stringlist.Strings[n], 2, Length(sorted_merge_puzzle_stringlist.Strings[n]));
          pos_of_quotes := Pos('"',temp_string) + 1;  // with last character ["]
          date_and_time_string := Copy(sorted_merge_puzzle_stringlist.Strings[n], 1, pos_of_quotes);
          solved_puzzle_1 := Copy(sorted_merge_puzzle_stringlist.Strings[n], pos_of_quotes + 1, Length(sorted_merge_puzzle_stringlist.Strings[n]) - pos_of_quotes);
          old_merge_puzzle_stringlist.Add(solved_puzzle_1 + date_and_time_string);
        end; // for n := 0 to sorted_merge_puzzle_stringlist.Count-1 do


        saved_all_puzzles_stringlist.Text := old_merge_puzzle_stringlist.Text;
        old_merge_puzzle_stringlist.SaveToFile(GetEnvironmentDirectoryPath(dirInternalAppStorage) + '/' + input_filename);
        //saved_all_puzzles_stringlist.Text := jFileProviderInternal.GetTextContent(input_filename);

        ShowMessage('Old and new solution files merged.');

      end; // else -> if(merge_solution_mode = 0) then
    end;
  ClickNo  :
    begin
      can_close := false;
    end;
end; // case YN of

end;

procedure TPuzzleGameForm.MoreAppsButtonClick(Sender: TObject);
begin

//jIntentManager1.SetAction(iaView);  //or 'android.intent.action.VIEW' // <<--- important to set

if(app_store = GOOGLE_STORE) then
begin
//jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://search?q=pname:'+'com.google.android.camera')); //works
//jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://dev?id=5448858571649033555')); // fails to work
//jIntentManager1.SetDataUri(jIntentManager1.ParseUri('market://developer?id=Cognaxon')); // fails to work
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://play.google.com/store/apps/developer?id=Cognaxon')); //works
end
else if(app_store = SAMSUNG_STORE) then
begin
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://games.cognaxon.com'));
end
else if(app_store = HUAWEI_STORE) then
begin
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://games.cognaxon.com'));
end
else if(app_store = XIAOMI_STORE) then
begin
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://global.app.mi.com/developer?lo=TR&la=en_US&id=1078111&developerName=Cognaxon&publisherName=Cognaxon'));
end
else if(app_store = AMAZON_STORE) then
begin
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://www.amazon.com/gp/mas/dl/android?s=Cognaxon')); //works
end
else
begin
jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://games.cognaxon.com'));
end;



jIntentManager1.StartActivity();

end;

procedure TPuzzleGameForm.OtherPlatformsButtonClick(Sender: TObject);
begin

  //jIntentManager1.SetAction(iaView);  //or 'android.intent.action.VIEW' // <<--- important to set

  jIntentManager1.SetDataUri(jIntentManager1.ParseUri('https://games.cognaxon.com/?page=kwazy_quilt_puzzle_no_7114'));

  jIntentManager1.StartActivity();


end;


procedure TPuzzleGameForm.SimplifySolution();
var
 n, temp_int: Integer;
 temp_bool: Boolean;
begin



for n := 0 to 12 do
begin
  if(piece_rotation_angle[n] = 360) then
  piece_rotation_angle[n] := 0;

  if(piece_rotation_angle[n] < 0) then
  piece_rotation_angle[n] := piece_rotation_angle[n] + 360;
end;


piece_rotation_angle[0] := 0;
piece_is_flipped[0] := false;

if ((piece_rotation_angle[1] = 0) or (piece_rotation_angle[1] = 180)) then
piece_is_flipped[1] := false;




n := 2;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 60) then
    begin
     piece_rotation_angle[n] := 0;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 0) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 300) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 240) then
    begin
      piece_rotation_angle[n] := 180;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 180) then
    begin
      piece_rotation_angle[n] := 240;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 300;
      piece_is_flipped[n] := false;
    end;
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do




if ((piece_rotation_angle[3] = 0) or (piece_rotation_angle[3] = 180)) then
begin
piece_is_flipped[3] := false;
piece_rotation_angle[3] := 0;
end;

if (piece_rotation_angle[3] > 180) then
piece_rotation_angle[3] := piece_rotation_angle[3] - 180;

n := 3;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 180) then
    begin
     piece_rotation_angle[n] := 0;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 60) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do




if ((piece_rotation_angle[4] = 0) or (piece_rotation_angle[4] = 180)) then
piece_is_flipped[4] := false;


n := 4;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 300) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 240) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 240;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 60) then
    begin
      piece_rotation_angle[n] := 300;
      piece_is_flipped[n] := false;
    end;
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do




if ((piece_rotation_angle[5] = 0) or (piece_rotation_angle[5] = 180)) then
piece_is_flipped[5] := false;


n := 5;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 300) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 240) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 240;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 60) then
    begin
      piece_rotation_angle[n] := 300;
      piece_is_flipped[n] := false;
    end;
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do



if ((piece_rotation_angle[6] = 0) or (piece_rotation_angle[6] = 120) or (piece_rotation_angle[6] = 240)) then
piece_rotation_angle[6] := 0;

if ((piece_rotation_angle[6] = 60) or (piece_rotation_angle[6] = 180) or (piece_rotation_angle[6] = 300)) then
piece_rotation_angle[6] := 60;

piece_is_flipped[6] := false;



// piece 7 flipped must remain flipped


n := 8;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 240) then
    begin
     piece_rotation_angle[n] := 240;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 300) then
    begin
      piece_rotation_angle[n] := 180;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 0) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 60) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 0;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 180) then
    begin
      piece_rotation_angle[n] := 300;
      piece_is_flipped[n] := false;
    end;
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do


n := 9;
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 180) then
    begin
     piece_rotation_angle[n] := 0;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
     piece_rotation_angle[n] := 60;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 60) then
    begin
     piece_rotation_angle[n] := 120;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 0) then
    begin
     piece_rotation_angle[n] := 180;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 300) then
    begin
     piece_rotation_angle[n] := 240;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 240) then
    begin
     piece_rotation_angle[n] := 300;
     piece_is_flipped[n] := false;
    end;
	end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do




if (piece_rotation_angle[10] > 180) then
piece_rotation_angle[10] := piece_rotation_angle[10] - 180;


if ((piece_rotation_angle[10] = 0) or (piece_rotation_angle[10] = 180)) then
begin
piece_is_flipped[10] := false;
piece_rotation_angle[10] := 0;
end;

if ((piece_rotation_angle[11] = 0) or (piece_rotation_angle[11] = 180)) then
piece_is_flipped[11] := false;

if ((piece_rotation_angle[12] = 0) or (piece_rotation_angle[12] = 180)) then
piece_is_flipped[12] := false;




for n := 10 to 12 do
begin
  if(piece_is_flipped[n] = true) then
  begin
    if (piece_rotation_angle[n] = 60) then
    begin
     piece_rotation_angle[n] := 300;
     piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 120) then
    begin
      piece_rotation_angle[n] := 240;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 240) then
    begin
      piece_rotation_angle[n] := 120;
      piece_is_flipped[n] := false;
    end
    else if (piece_rotation_angle[n] = 300) then
    begin
      piece_rotation_angle[n] := 60;
      piece_is_flipped[n] := false;
    end;
  end; // if(piece_is_flipped[n] = true)
end; // for n := 0 to 12 do


if (piece_rotation_angle[10] > 180) then
piece_rotation_angle[10] := piece_rotation_angle[10] - 180;




if (piece_slot_address[12] < piece_slot_address[11]) then
begin


temp_int := piece_slot_address[11];
piece_slot_address[11] := piece_slot_address[12];
piece_slot_address[12] := temp_int;

temp_int := piece_rotation_angle[11];
piece_rotation_angle[11] := piece_rotation_angle[12];
piece_rotation_angle[12] := temp_int;

temp_bool := piece_is_flipped[11];
piece_is_flipped[11] := piece_is_flipped[12];
piece_is_flipped[12] := temp_bool;


temp_int := piece12_top;
piece12_top := piece13_top;
piece13_top := temp_int;

temp_int := piece12_left;
piece12_left := piece13_left;
piece13_left := temp_int;

// Piece12.RedrawBitmap(); // Android Fix
// Piece13.RedrawBitmap(); // Android Fix
(*
saved_current_piece := current_piece;
current_piece := 12;
RotatePiece();    // causes Crash, instead we will use TableView.Refresh() after SimplifySolution() // Android Fix
current_piece := 13;
RotatePiece();  // causes Crash, instead we will use TableView.Refresh() after SimplifySolution() // Android Fix
current_piece := saved_current_piece;
*)



end; //if (piece_slot_address[12] < piece_slot_address[11])


(*
// debug purposes
for n := 9 to 12 do
begin
  if ((piece_is_flipped[n] = true) and (n <> 7)) then
  ShowMessage('piece_is_flipped[' + IntToStr(n) +'] = true');
end;
*)

end;





end.
